/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.gif;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import uk.co.mmscomputing.imageio.gif.GIFLZWInputStream;

public class GIFImageReader
extends ImageReader {
    private boolean gotHeader = false;
    private boolean gotImages = false;
    private Vector images = null;
    private int loops = -1;
    int width;
    int height;
    int background;
    double aspectRatio;
    boolean gcm = false;
    boolean sort = false;
    int colres;
    int colCount;
    int bitColCount;
    byte[][] gct;
    int pleft;
    int ptop;
    int pwidth;
    int pheight;
    int pcolCount = 0;
    int pbitColCount = 0;
    boolean psort = false;
    boolean pinterlaced = false;
    boolean plcm = false;
    byte[][] plct;

    protected GIFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.readAll();
        this.checkIndex(n);
        return (BufferedImage)this.images.elementAt(n);
    }

    public int getHeight(int n) throws IOException {
        this.readAll();
        this.checkIndex(n);
        return ((BufferedImage)this.images.elementAt(n)).getHeight();
    }

    public int getWidth(int n) throws IOException {
        this.readAll();
        this.checkIndex(n);
        return ((BufferedImage)this.images.elementAt(n)).getWidth();
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.readAll();
        this.checkIndex(n);
        ImageTypeSpecifier imageTypeSpecifier = null;
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    public int getNumImages(boolean bl) throws IOException {
        this.readAll();
        return this.images.size();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.readAll();
        this.checkIndex(n);
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    private void checkIndex(int n) {
        if (n > this.images.size()) {
            throw new IndexOutOfBoundsException("mmsc - GIFImageReader : Bad index in gif image reader");
        }
    }

    private byte[][] readColorTable(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)inputStream.read();
            byArray2[i] = (byte)inputStream.read();
            byArray3[i] = (byte)inputStream.read();
        }
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3};
        return byArrayArray;
    }

    private int readShort(InputStream inputStream) throws IOException {
        return inputStream.read() & 0xFF | (inputStream.read() & 0xFF) << 8;
    }

    private void readHeader(InputStream inputStream) throws IOException {
        if (this.gotHeader) {
            return;
        }
        this.gotHeader = true;
        byte[] byArray = new byte[]{(byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read()};
        if (byArray[0] != 71 || byArray[1] != 73 || byArray[2] != 70) {
            throw new IOException(this.getClass().getName() + ".readHeader:\n\tInvalid gif document : Missing 'GIF' byte sequence.");
        }
        byte[] byArray2 = new byte[]{(byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read()};
        if (!(byArray2[0] == 56 && byArray2[1] == 57 && byArray2[2] == 97 || byArray2[0] == 56 && byArray2[1] == 55 && byArray2[2] == 97)) {
            throw new IOException(this.getClass().getName() + ".readHeader:\n\tInvalid gif document : Version is missing or unsupported.");
        }
        this.width = this.readShort(inputStream);
        this.height = this.readShort(inputStream);
        int n = inputStream.read();
        this.background = inputStream.read();
        int n2 = inputStream.read();
        this.aspectRatio = n2 == 0 ? 1.0 : (double)((n2 + 15) / 64);
        this.gcm = (n & 0x80) != 0;
        this.colres = ((n & 0x70) >> 4) + 1;
        this.sort = (n & 8) != 0;
        this.bitColCount = (n & 7) + 1;
        this.colCount = 1 << this.bitColCount;
        this.gct = this.gcm ? this.readColorTable(inputStream, this.colCount) : (byte[][])null;
    }

    private void readPageHeader(InputStream inputStream) throws IOException {
        this.pleft = this.readShort(inputStream);
        this.ptop = this.readShort(inputStream);
        this.pwidth = this.readShort(inputStream);
        this.pheight = this.readShort(inputStream);
        int n = inputStream.read();
        this.pbitColCount = (n & 7) + 1;
        this.pcolCount = 1 << this.pbitColCount;
        this.psort = (n & 0x20) != 0;
        this.pinterlaced = (n & 0x40) != 0;
        this.plcm = (n & 0x80) != 0;
        this.plct = this.plcm ? this.readColorTable(inputStream, this.pcolCount) : (byte[][])null;
        System.out.println("GIF: left   =" + this.pleft);
        System.out.println("GIF: top    =" + this.ptop);
        System.out.println("GIF: width  =" + this.pwidth);
        System.out.println("GIF: height =" + this.pheight);
    }

    public void readExtension(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        switch (n) {
            case 1: {
                System.out.println("Plain Text Extension ! ");
                break;
            }
            case 249: {
                this.readCntl(inputStream);
                return;
            }
            case 254: {
                this.readComment(inputStream);
                return;
            }
            case 255: {
                this.readApp(inputStream);
                return;
            }
            default: {
                throw new IOException(this.getClass().getName() + ".readExtension\n\tIllegal GIF Extension Block !");
            }
        }
        int n2 = inputStream.read();
        while (n2 > 0) {
            inputStream.skip(n2);
            n2 = inputStream.read();
        }
    }

    private void readComment(InputStream inputStream) throws IOException {
        String string = "";
        int n = inputStream.read();
        while (n > 0) {
            for (int i = 0; i < n; ++i) {
                string = string + (char)inputStream.read();
            }
            n = inputStream.read();
        }
        System.out.println("Comment: " + string);
    }

    private void readApp(InputStream inputStream) throws IOException {
        int n;
        int n2;
        String string = "";
        int n3 = inputStream.read();
        for (n2 = 0; n2 < n3; ++n2) {
            string = string + (char)inputStream.read();
        }
        n3 = inputStream.read();
        if (string.equals("NETSCAPE2.0")) {
            n2 = 0;
            if (n3 == 3) {
                n = inputStream.read();
                ++n2;
                switch (n) {
                    case 1: {
                        this.loops = inputStream.read() | inputStream.read() << 8;
                        n2 += 2;
                        System.out.println("loops=" + this.loops);
                        break;
                    }
                    default: {
                        System.out.println("NO:" + n);
                    }
                }
            }
            while (n2 < n3) {
                n = inputStream.read();
                System.out.println("appl[" + n2 + "] 0x" + Integer.toHexString(n) + " " + (char)(n >= 32 ? n : 32) + " " + n);
                ++n2;
            }
            n3 = inputStream.read();
        } else {
            System.out.println("ID:" + string);
        }
        while (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                n = inputStream.read();
                System.out.println("appl[" + n2 + "] 0x" + Integer.toHexString(n) + " " + (char)(n >= 32 ? n : 32) + " " + n);
            }
            n3 = inputStream.read();
        }
    }

    private void readCntl(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if (n2 == 4) {
            String string = "\n\nGraphic Control Extension:";
            n = inputStream.read();
            switch (n >> 2 & 7) {
                case 0: {
                    string = string + "\n\tNo disposal specified.";
                    break;
                }
                case 1: {
                    string = string + "\n\tDo not dispose.";
                    break;
                }
                case 2: {
                    string = string + "\n\tRestore to background color.";
                    break;
                }
                case 3: {
                    string = string + "\n\tRestore to previous.";
                    break;
                }
                default: {
                    string = string + "\n\tUnknown disposal mode.";
                }
            }
            switch (n >> 1 & 1) {
                case 0: {
                    string = string + "\n\tUser input is not expected.";
                    break;
                }
                case 1: {
                    string = string + "\n\tUser input is expected.";
                }
            }
            switch (n & 1) {
                case 0: {
                    string = string + "\n\tTransparent Index is not given.";
                    break;
                }
                case 1: {
                    string = string + "\n\tTransparent Index is given.";
                }
            }
            int n3 = inputStream.read() | inputStream.read() << 8;
            string = string + "\n\tDelay: " + n3;
            int n4 = inputStream.read();
            string = string + "\n\tTransparency Index: " + n4 + "\n";
            System.out.println(string);
            n2 = inputStream.read();
        }
        while (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                n = inputStream.read();
                System.out.println("cntl[" + i + "] 0x" + Integer.toHexString(n) + " " + (char)(n >= 32 ? n : 32) + " " + n);
            }
            n2 = inputStream.read();
        }
    }

    private BufferedImage read(InputStream inputStream) throws IOException {
        this.readHeader(inputStream);
        int n = inputStream.read();
        while (n > 0) {
            switch (n) {
                case 44: {
                    this.readPageHeader(inputStream);
                    GIFLZWInputStream gIFLZWInputStream = new GIFLZWInputStream(inputStream);
                    byte[][] byArray = this.plct != null ? this.plct : this.gct;
                    int n2 = this.plct != null ? this.pcolCount : this.colCount;
                    int n3 = this.plct != null ? this.pbitColCount : this.bitColCount;
                    IndexColorModel indexColorModel = new IndexColorModel(n3, this.colCount, byArray[0], byArray[1], byArray[2]);
                    BufferedImage bufferedImage = new BufferedImage(this.pwidth, this.pheight, 13, indexColorModel);
                    WritableRaster writableRaster = bufferedImage.getRaster();
                    DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                    byte[] byArray2 = dataBufferByte.getData();
                    gIFLZWInputStream.read(byArray2);
                    int n4 = gIFLZWInputStream.read();
                    return bufferedImage;
                }
                case 33: {
                    this.readExtension(inputStream);
                    break;
                }
                case 59: {
                    return null;
                }
                default: {
                    throw new IOException(this.getClass().getName() + ".read\n\tIllegal GIF block : " + (char)n + " [0x" + Integer.toHexString(n) + "]");
                }
            }
            n = inputStream.read();
        }
        throw new IOException(this.getClass().getName() + ".read\n\tDid not find GIF Image Descriptor AND/OR GIF Terminator!");
    }

    private void readAll() throws IOException {
        if (!this.gotImages) {
            BufferedImage bufferedImage;
            this.gotImages = true;
            GIFFilterInputStream gIFFilterInputStream = new GIFFilterInputStream((ImageInputStream)this.getInput());
            this.images = new Vector();
            while ((bufferedImage = this.read(gIFFilterInputStream)) != null) {
                this.images.add(bufferedImage);
            }
        }
    }

    private static class GIFFilterInputStream
    extends InputStream {
        private ImageInputStream in;
        private byte[] buffer;
        private int count;
        private int max;
        int pos = 0;

        public GIFFilterInputStream(ImageInputStream imageInputStream) {
            this.in = imageInputStream;
            this.buffer = new byte[4096];
            this.count = 0;
            this.max = 0;
        }

        public int read() throws IOException {
            if (this.count == this.max) {
                this.max = this.in.read(this.buffer);
                if (this.max == -1) {
                    this.count = -1;
                    return -1;
                }
                this.count = 0;
            }
            ++this.pos;
            return this.buffer[this.count++] & 0xFF;
        }
    }
}

