/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.gif;

import java.io.IOException;
import java.io.OutputStream;

public class GIFBitOutputStream
extends OutputStream {
    private int buf = 0;
    private int off = 0;
    private int count = 0;
    private OutputStream out;
    private byte[] buffer = new byte[255];

    public GIFBitOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        this.buf = 0;
        this.off = 0;
        this.count = 0;
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void writeBits(int n, int n2) throws IOException {
        n2 += this.off;
        this.buf |= (n <<= this.off);
        while (n2 >= 8) {
            this.buffer[this.count++] = (byte)(this.buf & 0xFF);
            this.buf >>= 8;
            n2 -= 8;
            if (this.count != this.buffer.length) continue;
            this.out.write(this.count);
            this.out.write(this.buffer);
            this.count = 0;
        }
        this.off = n2 & 7;
    }

    public void flush() throws IOException {
        if (this.off > 0) {
            this.writeBits(0, 7);
        }
        this.buf = 0;
        this.off = 0;
        if (this.count > 0) {
            this.out.write(this.count);
            this.out.write(this.buffer, 0, this.count);
            this.count = 0;
            this.out.write(this.count);
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

