/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.imageio.bmp;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import uk.co.mmscomputing.imageio.bmp.BMPConstants;
import uk.co.mmscomputing.imageio.bmp.BMPMetadata;

public class BMPImageReader
extends ImageReader
implements BMPConstants {
    private boolean gotHeader = false;
    private int size = 0;
    private int offset = 0;
    private int headerSize = 40;
    private int width;
    private int height;
    private int planes = 1;
    private int bitsPerPixel = 24;
    private int compression = 0;
    private int sizeImage;
    private int xPelsPerMeter = 2953;
    private int yPelsPerMeter = 2953;
    private int clrUsed = 0;
    private int clrImportant = 0;
    private IndexColorModel icm = null;
    private int redMask = 0;
    private int greenMask = 0;
    private int blueMask = 0;

    protected BMPImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        return this.read((ImageInputStream)this.getInput());
    }

    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader((ImageInputStream)this.getInput());
        return this.height;
    }

    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader((ImageInputStream)this.getInput());
        return this.width;
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader((ImageInputStream)this.getInput());
        ArrayList arrayList = new ArrayList();
        return arrayList.iterator();
    }

    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        BMPMetadata bMPMetadata = new BMPMetadata();
        bMPMetadata.setWidth(this.getWidth(n));
        bMPMetadata.setHeight(this.getHeight(n));
        bMPMetadata.setBitsPerPixel(this.bitsPerPixel);
        bMPMetadata.setCompression(this.compression);
        bMPMetadata.setImageSize(this.sizeImage);
        bMPMetadata.setXPixelsPerMeter(this.xPelsPerMeter);
        bMPMetadata.setYPixelsPerMeter(this.yPelsPerMeter);
        bMPMetadata.setColorsUsed(this.clrUsed);
        bMPMetadata.setIndexColorModel(this.icm);
        bMPMetadata.setColorsImportant(this.clrImportant);
        bMPMetadata.setRedMask(this.redMask);
        bMPMetadata.setGreenMask(this.greenMask);
        bMPMetadata.setBlueMask(this.blueMask);
        return bMPMetadata;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".checkIndex:\n\tBad index in bmp image reader.");
        }
    }

    int getColorsInPalette() {
        if (this.clrUsed != 0) {
            return this.clrUsed;
        }
        if (this.bitsPerPixel < 16) {
            return 1 << this.bitsPerPixel;
        }
        return 0;
    }

    private void readHeader(ImageInputStream imageInputStream) throws IOException {
        int n;
        if (this.gotHeader) {
            return;
        }
        this.gotHeader = true;
        imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray = new byte[2];
        imageInputStream.readFully(byArray);
        if (byArray[0] != 66 || byArray[1] != 77) {
            throw new IOException("Invalid BMP 3.0 File.");
        }
        this.size = imageInputStream.readInt();
        imageInputStream.readUnsignedShort();
        imageInputStream.readUnsignedShort();
        this.offset = imageInputStream.readInt();
        this.headerSize = imageInputStream.readInt();
        if (this.headerSize == 12) {
            this.width = imageInputStream.readUnsignedShort();
            this.height = imageInputStream.readUnsignedShort();
            this.planes = imageInputStream.readUnsignedShort();
            this.bitsPerPixel = imageInputStream.readUnsignedShort();
            this.compression = 0;
            this.xPelsPerMeter = 2953;
            this.yPelsPerMeter = 2953;
            this.clrUsed = 0;
            this.clrImportant = 0;
        } else {
            this.width = imageInputStream.readInt();
            this.height = imageInputStream.readInt();
            this.planes = imageInputStream.readUnsignedShort();
            this.bitsPerPixel = imageInputStream.readUnsignedShort();
            this.compression = imageInputStream.readInt();
            this.sizeImage = imageInputStream.readInt();
            this.xPelsPerMeter = imageInputStream.readInt();
            this.yPelsPerMeter = imageInputStream.readInt();
            this.clrUsed = imageInputStream.readInt();
            this.clrImportant = imageInputStream.readInt();
        }
        if (this.sizeImage == 0) {
            this.sizeImage = (this.width * this.bitsPerPixel + 31 >> 5 << 2) * this.height;
        }
        if ((n = this.getColorsInPalette()) > 0) {
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            byte[] byArray4 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray4[i] = (byte)imageInputStream.read();
                byArray3[i] = (byte)imageInputStream.read();
                byArray2[i] = (byte)imageInputStream.read();
                imageInputStream.read();
            }
            this.icm = new IndexColorModel(this.bitsPerPixel, n, byArray2, byArray3, byArray4);
        }
        if (this.compression == 3) {
            this.redMask = imageInputStream.readInt();
            this.greenMask = imageInputStream.readInt();
            this.blueMask = imageInputStream.readInt();
        } else if (this.bitsPerPixel == 16) {
            this.redMask = 31744;
            this.greenMask = 992;
            this.blueMask = 31;
        } else if (this.bitsPerPixel == 32) {
            this.redMask = 0xFF0000;
            this.greenMask = 65280;
            this.blueMask = 255;
        }
        int n2 = this.offset - (14 + this.headerSize + n * 4 + (this.compression == 3 ? 12 : 0));
        if (n2 > 0) {
            imageInputStream.skipBytes(n2);
        }
        if (this.compression == 2 || this.compression == 1) {
            throw new IOException(this.getClass().getName() + ".readHeader:\n\tCannot read Run Length Encoded BMP Files.");
        }
    }

    private BufferedImage read(ImageInputStream imageInputStream) throws IOException {
        this.readHeader(imageInputStream);
        switch (this.bitsPerPixel) {
            case 1: {
                return this.unpack01(imageInputStream, this.icm);
            }
            case 4: {
                return this.unpack04(imageInputStream, this.icm);
            }
            case 8: {
                return this.unpack08(imageInputStream, this.icm);
            }
            case 16: {
                return this.unpack16(imageInputStream);
            }
            case 24: {
                return this.unpack24(imageInputStream);
            }
            case 32: {
                return this.unpack32(imageInputStream);
            }
        }
        throw new IOException(this.getClass().getName() + ".read:\n    Cannot read BMP with depth=" + (1 << this.bitsPerPixel));
    }

    void copyImage(byte[] byArray, int n, ImageInputStream imageInputStream) throws IOException {
        int n2 = (this.width * this.bitsPerPixel + 31 >> 5 << 2) - n;
        for (int i = (this.height - 1) * n; i >= 0; i -= n) {
            imageInputStream.read(byArray, i, n);
            imageInputStream.skipBytes(n2);
        }
    }

    int getColorValue(int n, int n2) {
        int n3 = n & n2;
        while ((n2 & Integer.MIN_VALUE) == 0) {
            n3 <<= 1;
            n2 <<= 1;
        }
        return n3 >> 24 & 0xFF;
    }

    BufferedImage unpack32(ImageInputStream imageInputStream) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        if (this.redMask == 0xFF0000 && this.greenMask == 65280 && this.blueMask == 255) {
            for (int i = (this.height - 1) * this.width; i >= 0; i -= this.width) {
                imageInputStream.readFully(nArray, i, this.width);
            }
        } else {
            for (int i = (this.height - 1) * this.width; i >= 0; i -= this.width) {
                for (int j = 0; j < this.width; ++j) {
                    int n = imageInputStream.readInt();
                    int n2 = this.getColorValue(n, this.redMask);
                    int n3 = this.getColorValue(n, this.greenMask);
                    int n4 = this.getColorValue(n, this.blueMask);
                    nArray[i + j] = n2 << 16 | n3 << 8 | n4;
                }
            }
        }
        return bufferedImage;
    }

    BufferedImage unpack24(ImageInputStream imageInputStream) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 5);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        this.copyImage(dataBufferByte.getData(), this.width * 3, imageInputStream);
        return bufferedImage;
    }

    BufferedImage unpack16(ImageInputStream imageInputStream) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 9);
        DataBufferUShort dataBufferUShort = (DataBufferUShort)bufferedImage.getRaster().getDataBuffer();
        short[] sArray = dataBufferUShort.getData();
        int n = (this.width * this.bitsPerPixel + 31 >> 5 << 2) - (this.width << 1);
        if (this.redMask == 31744 && this.greenMask == 992 && this.blueMask == 31) {
            for (int i = (this.height - 1) * this.width; i >= 0; i -= this.width) {
                imageInputStream.readFully(sArray, i, this.width);
                imageInputStream.skipBytes(n);
            }
        } else {
            for (int i = (this.height - 1) * this.width; i >= 0; i -= this.width) {
                for (int j = 0; j < this.width; ++j) {
                    short s = imageInputStream.readShort();
                    int n2 = this.getColorValue(s, this.redMask) & 0x1F;
                    int n3 = this.getColorValue(s, this.greenMask) & 0x1F;
                    int n4 = this.getColorValue(s, this.blueMask) & 0x1F;
                    sArray[i + j] = (short)(n2 << 10 | n3 << 5 | n4);
                }
                imageInputStream.skipBytes(n);
            }
        }
        return bufferedImage;
    }

    BufferedImage unpack08(ImageInputStream imageInputStream, IndexColorModel indexColorModel) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 13, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        this.copyImage(dataBufferByte.getData(), this.width, imageInputStream);
        return bufferedImage;
    }

    BufferedImage unpack04(ImageInputStream imageInputStream, IndexColorModel indexColorModel) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 12, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        this.copyImage(dataBufferByte.getData(), this.width + 1 >> 1, imageInputStream);
        return bufferedImage;
    }

    BufferedImage unpack01(ImageInputStream imageInputStream, IndexColorModel indexColorModel) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 12, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        this.copyImage(dataBufferByte.getData(), this.width + 7 >> 3, imageInputStream);
        return bufferedImage;
    }
}

