/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.image.operators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.image.operators.ImageTypeConvertOp;

public class ImageTypeConvertOpPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static Properties params = new Properties();
    private JDialog dialog;
    private boolean cancelled = false;
    private JRadioButton buttonByteBinary;
    private JRadioButton buttonByteIndexed;
    private JRadioButton buttonByteGrayScaled;
    private JRadioButton buttonBPP1;
    private JRadioButton buttonBPP2;
    private JRadioButton buttonBPP4;
    private JRadioButton buttonBPP8;
    private JRadioButton buttonBPP16;
    private JRadioButton buttonBPP24;
    private JRadioButton buttonBPP32;
    private JSlider sliderThreshold;
    private Semaphore blocker = new Semaphore(0, true);

    public ImageTypeConvertOpPanel() {
        super(new BorderLayout());
        this.add((Component)this.getMainCentralPanel(), "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton("ok");
        jButton.setActionCommand("ok");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        jButton = new JButton("cancel");
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
    }

    private JPanel getMainCentralPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(new EtchedBorder());
        jPanel.add(this.getImageTypePanel());
        jPanel.add(this.getBPPPanel());
        jPanel.add(this.getQualityPanel());
        return jPanel;
    }

    private JPanel getImageTypePanel() {
        this.buttonByteBinary = new JRadioButton("Byte Binary");
        this.buttonByteBinary.setActionCommand("ByteBinary");
        this.buttonByteBinary.addActionListener(this);
        this.buttonByteBinary.setSelected(true);
        params.setProperty("type", Integer.toString(12));
        this.buttonByteIndexed = new JRadioButton("Byte Indexed");
        this.buttonByteIndexed.setActionCommand("ByteIndexed");
        this.buttonByteIndexed.addActionListener(this);
        this.buttonByteGrayScaled = new JRadioButton("Byte Gray Scale");
        this.buttonByteGrayScaled.setActionCommand("ByteGrayScale");
        this.buttonByteGrayScaled.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.buttonByteBinary);
        buttonGroup.add(this.buttonByteIndexed);
        buttonGroup.add(this.buttonByteGrayScaled);
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Image Type"));
        jPanel.add(this.buttonByteBinary);
        jPanel.add(this.buttonByteIndexed);
        jPanel.add(this.buttonByteGrayScaled);
        return jPanel;
    }

    private JPanel getBPPPanel() {
        this.buttonBPP1 = new JRadioButton("1");
        this.buttonBPP1.setActionCommand("bpp1");
        this.buttonBPP1.addActionListener(this);
        this.buttonBPP1.setSelected(true);
        params.setProperty("bpp", "1");
        this.buttonBPP2 = new JRadioButton("2");
        this.buttonBPP2.setActionCommand("bpp2");
        this.buttonBPP2.addActionListener(this);
        this.buttonBPP4 = new JRadioButton("4");
        this.buttonBPP4.setActionCommand("bpp4");
        this.buttonBPP4.addActionListener(this);
        this.buttonBPP8 = new JRadioButton("8");
        this.buttonBPP8.setActionCommand("bpp8");
        this.buttonBPP8.addActionListener(this);
        this.buttonBPP8.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.buttonBPP1);
        buttonGroup.add(this.buttonBPP2);
        buttonGroup.add(this.buttonBPP4);
        buttonGroup.add(this.buttonBPP8);
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Bits Per Pixel"));
        jPanel.add(this.buttonBPP1);
        jPanel.add(this.buttonBPP2);
        jPanel.add(this.buttonBPP4);
        jPanel.add(this.buttonBPP8);
        return jPanel;
    }

    private boolean setType(String string) {
        if (string.equals("ByteBinary")) {
            params.setProperty("type", Integer.toString(12));
            this.buttonByteBinary.setSelected(true);
            this.buttonBPP1.setEnabled(true);
            this.buttonBPP2.setEnabled(true);
            this.buttonBPP4.setEnabled(true);
            this.buttonBPP8.setEnabled(false);
            if (this.buttonBPP8.isSelected()) {
                this.setBPP("bpp4");
            }
        } else if (string.equals("ByteIndexed")) {
            params.setProperty("type", Integer.toString(13));
            this.buttonByteIndexed.setSelected(true);
            this.buttonBPP1.setEnabled(false);
            this.buttonBPP2.setEnabled(false);
            this.buttonBPP4.setEnabled(false);
            this.buttonBPP8.setEnabled(true);
            this.setBPP("bpp8");
        } else if (string.equals("ByteGrayScale")) {
            params.setProperty("type", Integer.toString(10));
            this.buttonByteGrayScaled.setSelected(true);
            this.buttonBPP1.setEnabled(false);
            this.buttonBPP2.setEnabled(false);
            this.buttonBPP4.setEnabled(false);
            this.buttonBPP8.setEnabled(true);
            this.setBPP("bpp8");
        } else {
            return false;
        }
        return true;
    }

    private boolean setBPP(String string) {
        if (string.equals("bpp1")) {
            params.setProperty("bpp", "1");
            this.buttonBPP1.setSelected(true);
            this.sliderThreshold.setEnabled(true);
        } else if (string.equals("bpp2")) {
            params.setProperty("bpp", "2");
            this.buttonBPP2.setSelected(true);
            this.sliderThreshold.setEnabled(false);
        } else if (string.equals("bpp4")) {
            params.setProperty("bpp", "4");
            this.buttonBPP4.setSelected(true);
            this.sliderThreshold.setEnabled(false);
        } else if (string.equals("bpp8")) {
            params.setProperty("bpp", "8");
            this.buttonBPP8.setSelected(true);
            this.sliderThreshold.setEnabled(false);
        } else {
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            this.cancelled = false;
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            this.blocker.release();
        } else if (string.equals("cancel")) {
            this.cancelled = true;
            if (this.dialog != null) {
                this.dialog.dispose();
            }
            this.blocker.release();
        } else if (this.setType(string) || this.setBPP(string)) {
            // empty if block
        }
    }

    private JPanel getQualityPanel() {
        int n = 50;
        params.setProperty("threshold", Integer.toString(n));
        this.sliderThreshold = new JSlider(0, 0, 100, n);
        this.sliderThreshold.addChangeListener(this);
        this.sliderThreshold.setEnabled(true);
        this.sliderThreshold.setMinorTickSpacing(2);
        this.sliderThreshold.setMajorTickSpacing(10);
        this.sliderThreshold.setPaintTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 100; i += 10) {
            ((Dictionary)hashtable).put(new Integer(i), new JLabel(Integer.toString(i)));
        }
        this.sliderThreshold.setLabelTable(hashtable);
        this.sliderThreshold.setPaintLabels(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Threshold"));
        jPanel.add((Component)this.sliderThreshold, "Center");
        return jPanel;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting() && jSlider == this.sliderThreshold) {
            int n = jSlider.getValue();
            if (n <= 0) {
                n = 1;
                jSlider.setValue(1);
            }
            params.setProperty("threshold", Integer.toString(n));
        }
    }

    public void display() {
        try {
            this.dialog = new JDialog((Frame)null, "Image Type Converter Settings", false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(null);
            this.dialog.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".display:\n\t" + exception);
            exception.printStackTrace();
        }
    }

    public ImageTypeConvertOp activate() {
        this.display();
        try {
            this.blocker.acquire();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if (this.cancelled) {
            return null;
        }
        return new ImageTypeConvertOp(params);
    }
}

