/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.image.operators;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;

public class HeckbertQuantiziser {
    private int[] colourCube;
    private int[] rColourTable;
    private int[] gColourTable;
    private int[] bColourTable;
    private int cti;
    private int bitsPerPixel;
    private int maxColours;
    private boolean mediancut;
    private boolean dither;

    public HeckbertQuantiziser() {
        this(1, true, true);
    }

    public HeckbertQuantiziser(int n, boolean bl, boolean bl2) {
        this.bitsPerPixel = n;
        this.maxColours = 1 << this.bitsPerPixel;
        this.colourCube = new int[32768];
        this.rColourTable = new int[this.maxColours];
        this.gColourTable = new int[this.maxColours];
        this.bColourTable = new int[this.maxColours];
        this.cti = 0;
        this.mediancut = bl;
        this.dither = bl2;
    }

    public BufferedImage filter(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = bufferedImage.getWidth();
        int n11 = bufferedImage.getHeight();
        for (n9 = 0; n9 < n11; ++n9) {
            for (n8 = 0; n8 < n10; ++n8) {
                n7 = bufferedImage.getRGB(n8, n9);
                n6 = n7 >> 9 & 0x7C00;
                n5 = n7 >> 6 & 0x3E0;
                n4 = n7 >> 3 & 0x1F;
                int n12 = n6 | n5 | n4;
                this.colourCube[n12] = this.colourCube[n12] + 1;
            }
        }
        if (this.mediancut) {
            this.cti = 0;
            this.medianCut(0, 31, 0, 31, 0, 31, this.maxColours, n10 * n11);
        } else {
            this.cti = 0;
            this.popularity();
        }
        for (n9 = 0; n9 < 32768; ++n9) {
            n8 = n9 >> 7 & 0xF8;
            n7 = n9 >> 2 & 0xF8;
            n6 = n9 << 3 & 0xF8;
            n5 = this.rColourTable[0] - n8;
            n4 = this.gColourTable[0] - n7;
            int n13 = this.bColourTable[0] - n6;
            int n14 = n5 * n5 + n4 * n4 + n13 * n13;
            n3 = 0;
            for (n2 = 0; n2 < this.maxColours; ++n2) {
                n5 = this.rColourTable[n2] - n8;
                n4 = this.gColourTable[n2] - n7;
                n13 = this.bColourTable[n2] - n6;
                n = n5 * n5 + n4 * n4 + n13 * n13;
                if (n >= n14) continue;
                n14 = n;
                n3 = n2;
            }
            this.colourCube[n9] = n3;
        }
        byte[] byArray = new byte[this.cti];
        byte[] byArray2 = new byte[this.cti];
        byte[] byArray3 = new byte[this.cti];
        for (n6 = 0; n6 < this.cti; ++n6) {
            byArray[n6] = (byte)this.rColourTable[n6];
            byArray2[n6] = (byte)this.gColourTable[n6];
            byArray3[n6] = (byte)this.bColourTable[n6];
        }
        IndexColorModel indexColorModel = new IndexColorModel(this.bitsPerPixel, this.cti, byArray, byArray2, byArray3);
        BufferedImage bufferedImage2 = this.bitsPerPixel <= 4 ? new BufferedImage(n10, n11, 12, indexColorModel) : new BufferedImage(n10, n11, 13, indexColorModel);
        WritableRaster writableRaster = bufferedImage2.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray4 = dataBufferByte.getData();
        switch (this.bitsPerPixel) {
            case 4: {
                n3 = n10 + 1 >> 1 << 1;
                break;
            }
            case 2: {
                n3 = n10 + 3 >> 2 << 2;
                break;
            }
            case 1: {
                n3 = n10 + 7 >> 3 << 3;
                break;
            }
            default: {
                n3 = n10;
            }
        }
        for (n2 = 0; n2 < n11; ++n2) {
            for (n = 0; n < n10; ++n) {
                int n15 = bufferedImage.getRGB(n, n2);
                int n16 = n15 >> 9 & 0x7C00;
                int n17 = n15 >> 6 & 0x3E0;
                int n18 = n15 >> 3 & 0x1F;
                int n19 = this.colourCube[n16 | n17 | n18];
                if (this.bitsPerPixel == 8) {
                    byArray4[n2 * n3 + n] = (byte)n19;
                } else if (this.bitsPerPixel == 4) {
                    switch (n % 2) {
                        case 0: {
                            byArray4[n2 * n3 + n >> 1] = (byte)(n19 << 4);
                            break;
                        }
                        case 1: {
                            int n20 = n2 * n3 + n >> 1;
                            byArray4[n20] = (byte)(byArray4[n20] | (byte)n19);
                        }
                    }
                } else if (this.bitsPerPixel == 2) {
                    switch (n % 4) {
                        case 0: {
                            byArray4[n2 * n3 + n >> 2] = (byte)(n19 << 6);
                            break;
                        }
                        case 1: {
                            int n21 = n2 * n3 + n >> 2;
                            byArray4[n21] = (byte)(byArray4[n21] | (byte)(n19 << 4));
                            break;
                        }
                        case 2: {
                            int n22 = n2 * n3 + n >> 2;
                            byArray4[n22] = (byte)(byArray4[n22] | (byte)(n19 << 2));
                            break;
                        }
                        case 3: {
                            int n23 = n2 * n3 + n >> 2;
                            byArray4[n23] = (byte)(byArray4[n23] | (byte)n19);
                        }
                    }
                } else if (this.bitsPerPixel == 1) {
                    switch (n % 8) {
                        case 0: {
                            byArray4[n2 * n3 + n >> 3] = (byte)(n19 << 7);
                            break;
                        }
                        case 1: {
                            int n24 = n2 * n3 + n >> 3;
                            byArray4[n24] = (byte)(byArray4[n24] | (byte)(n19 << 6));
                            break;
                        }
                        case 2: {
                            int n25 = n2 * n3 + n >> 3;
                            byArray4[n25] = (byte)(byArray4[n25] | (byte)(n19 << 5));
                            break;
                        }
                        case 3: {
                            int n26 = n2 * n3 + n >> 3;
                            byArray4[n26] = (byte)(byArray4[n26] | (byte)(n19 << 4));
                            break;
                        }
                        case 4: {
                            int n27 = n2 * n3 + n >> 3;
                            byArray4[n27] = (byte)(byArray4[n27] | (byte)(n19 << 3));
                            break;
                        }
                        case 5: {
                            int n28 = n2 * n3 + n >> 3;
                            byArray4[n28] = (byte)(byArray4[n28] | (byte)(n19 << 2));
                            break;
                        }
                        case 6: {
                            int n29 = n2 * n3 + n >> 3;
                            byArray4[n29] = (byte)(byArray4[n29] | (byte)(n19 << 1));
                            break;
                        }
                        case 7: {
                            int n30 = n2 * n3 + n >> 3;
                            byArray4[n30] = (byte)(byArray4[n30] | (byte)n19);
                        }
                    }
                }
                if (!this.dither) continue;
                int n31 = (n15 >> 16 & 0xFF) - this.rColourTable[n19];
                int n32 = (n15 >> 8 & 0xFF) - this.gColourTable[n19];
                int n33 = (n15 & 0xFF) - this.bColourTable[n19];
                if (n < n10 - 1) {
                    bufferedImage.setRGB(n + 1, n2, this.dither1(bufferedImage.getRGB(n + 1, n2), n31, n32, n33));
                }
                if (n2 < n11 - 1) {
                    bufferedImage.setRGB(n, n2 + 1, this.dither1(bufferedImage.getRGB(n, n2 + 1), n31, n32, n33));
                }
                if (n >= n10 - 1 || n2 >= n11 - 1) continue;
                bufferedImage.setRGB(n + 1, n2 + 1, this.dither2(bufferedImage.getRGB(n + 1, n2 + 1), n31, n32, n33));
            }
        }
        return bufferedImage2;
    }

    private int dither1(int n, int n2, int n3, int n4) {
        int n5 = (n >> 16 & 0xFF) + (n2 * 3 >> 3);
        if (n5 < 0) {
            n5 = 0;
        } else if (255 < n5) {
            n5 = 255;
        }
        int n6 = (n >> 8 & 0xFF) + (n3 * 3 >> 3);
        if (n6 < 0) {
            n6 = 0;
        } else if (255 < n6) {
            n6 = 255;
        }
        int n7 = (n & 0xFF) + (n4 * 3 >> 3);
        if (n7 < 0) {
            n7 = 0;
        } else if (255 < n7) {
            n7 = 255;
        }
        return n5 << 16 | n6 << 8 | n7;
    }

    private int dither2(int n, int n2, int n3, int n4) {
        int n5 = (n >> 16 & 0xFF) + (n2 >> 2);
        if (n5 < 0) {
            n5 = 0;
        } else if (255 < n5) {
            n5 = 255;
        }
        int n6 = (n >> 8 & 0xFF) + (n2 >> 2);
        if (n6 < 0) {
            n6 = 0;
        } else if (255 < n6) {
            n6 = 255;
        }
        int n7 = (n & 0xFF) + (n4 >> 2);
        if (n7 < 0) {
            n7 = 0;
        } else if (255 < n7) {
            n7 = 255;
        }
        return n5 << 16 | n6 << 8 | n7;
    }

    private void popularity() {
        for (int i = 0; i < this.maxColours; ++i) {
            int n = 0;
            int n2 = this.colourCube[0];
            for (int j = 1; j < 32768; ++j) {
                if (this.colourCube[j] <= n2) continue;
                n2 = this.colourCube[j];
                n = j;
            }
            this.colourCube[n] = 1;
            this.rColourTable[i] = n >> 7 & 0xF8;
            this.gColourTable[i] = n >> 2 & 0xF8;
            this.bColourTable[i] = n << 3 & 0xF8;
            ++this.cti;
        }
    }

    private void medianCut(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (0 < n8) {
            int n9 = n2 - n;
            int n10 = n4 - n3;
            int n11 = n6 - n5;
            if (n9 == 0 && n10 == 0 && n11 == 0) {
                this.rColourTable[this.cti] = n << 3;
                this.gColourTable[this.cti] = n3 << 3;
                this.bColourTable[this.cti] = n5 << 3;
                ++this.cti;
            } else if (n7 == 1 || n8 == 1) {
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                for (int i = n; i <= n2; ++i) {
                    for (int j = n3; j <= n4; ++j) {
                        for (int k = n5; k <= n6; ++k) {
                            int n15 = this.colourCube[i << 10 | j << 5 | k];
                            if (0 >= n15) continue;
                            n12 += i * n15;
                            n13 += j * n15;
                            n14 += k * n15;
                        }
                    }
                }
                this.rColourTable[this.cti] = n12 / n8 << 3;
                this.gColourTable[this.cti] = n13 / n8 << 3;
                this.bColourTable[this.cti] = n14 / n8 << 3;
                ++this.cti;
            } else if (n11 > n10 && n11 > n9) {
                int n16 = 0;
                int n17 = 0;
                int n18 = n5 - 1;
                while (n16 < n8 / 2) {
                    ++n18;
                    n17 = n16;
                    for (int i = n; i <= n2; ++i) {
                        for (int j = n3; j <= n4; ++j) {
                            n16 += this.colourCube[i << 10 | j << 5 | n18];
                        }
                    }
                }
                if (n18 < n6) {
                    this.medianCut(n, n2, n3, n4, n5, n18, n7 / 2, n16);
                    this.medianCut(n, n2, n3, n4, n18 + 1, n6, n7 / 2, n8 - n16);
                } else {
                    this.medianCut(n, n2, n3, n4, n5, n18 - 1, n7 / 2, n17);
                    this.medianCut(n, n2, n3, n4, n18, n6, n7 / 2, n8 - n17);
                }
            } else if (n10 > n9) {
                int n19 = 0;
                int n20 = 0;
                int n21 = n3 - 1;
                while (n19 < n8 / 2) {
                    ++n21;
                    n20 = n19;
                    for (int i = n; i <= n2; ++i) {
                        for (int j = n5; j <= n6; ++j) {
                            n19 += this.colourCube[i << 10 | n21 << 5 | j];
                        }
                    }
                }
                if (n21 < n4) {
                    this.medianCut(n, n2, n3, n21, n5, n6, n7 / 2, n19);
                    this.medianCut(n, n2, n21 + 1, n4, n5, n6, n7 / 2, n8 - n19);
                } else {
                    this.medianCut(n, n2, n3, n21 - 1, n5, n6, n7 / 2, n20);
                    this.medianCut(n, n2, n21, n4, n5, n6, n7 / 2, n8 - n20);
                }
            } else {
                int n22 = 0;
                int n23 = 0;
                int n24 = n - 1;
                while (n22 < n8 / 2) {
                    ++n24;
                    n23 = n22;
                    for (int i = n3; i <= n4; ++i) {
                        for (int j = n5; j <= n6; ++j) {
                            n22 += this.colourCube[n24 << 10 | i << 5 | j];
                        }
                    }
                }
                if (n24 < n2) {
                    this.medianCut(n, n24, n3, n4, n5, n6, n7 / 2, n22);
                    this.medianCut(n24 + 1, n2, n3, n4, n5, n6, n7 / 2, n8 - n22);
                } else {
                    this.medianCut(n, n24 - 1, n3, n4, n5, n6, n7 / 2, n23);
                    this.medianCut(n24, n2, n3, n4, n5, n6, n7 / 2, n8 - n23);
                }
            }
        }
    }
}

