/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.image.operators;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import uk.co.mmscomputing.image.operators.Operator;

public class DekkerQuantiziser
extends Operator {
    public static final int ncycles = 100;
    public static final int netsize = 256;
    public static final int specials = 3;
    public static final int bgColour = 2;
    public static final int cutnetsize = 253;
    public static final int maxnetpos = 255;
    public static final int initrad = 32;
    public static final int radiusbiasshift = 6;
    public static final int radiusbias = 64;
    public static final int initBiasRadius = 2048;
    public static final int radiusdec = 30;
    public static final int alphabiasshift = 10;
    public static final int initalpha = 1024;
    public static final double gamma = 1024.0;
    public static final double beta = 9.765625E-4;
    public static final double betagamma = 1.0;
    private double[][] network = new double[256][3];
    protected int[][] colormap = new int[256][4];
    private int[] netindex = new int[256];
    private double[] bias = new double[256];
    private double[] freq = new double[256];
    public static final int prime1 = 499;
    public static final int prime2 = 491;
    public static final int prime3 = 487;
    public static final int prime4 = 503;
    public static final int maxprime = 503;
    private int samplefac = 0;

    public DekkerQuantiziser() {
        this(1);
    }

    public DekkerQuantiziser(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 30) {
            n = 30;
        }
        this.samplefac = n;
    }

    public BufferedImage filter(BufferedImage bufferedImage) {
        int n;
        this.setUpArrays();
        this.learn(bufferedImage);
        this.fix();
        this.inxbuild();
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (n = 0; n < 256; ++n) {
            byArray[n] = (byte)this.colormap[n][2];
            byArray2[n] = (byte)this.colormap[n][1];
            byArray3[n] = (byte)this.colormap[n][0];
        }
        n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n, 13, indexColorModel);
        WritableRaster writableRaster = bufferedImage2.getRaster();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray4 = dataBufferByte.getData();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = bufferedImage.getRGB(j, i);
                int n4 = n3 & 0xFF000000;
                int n5 = n3 >> 16 & 0xFF;
                int n6 = n3 >> 8 & 0xFF;
                int n7 = n3 & 0xFF;
                byArray4[i * n2 + j] = (byte)(n4 | this.inxsearch(n5, n6, n7));
            }
        }
        System.out.println("Dekker Quantiziser finished!");
        return bufferedImage2;
    }

    private void setUpArrays() {
        int n;
        this.network[0][0] = 0.0;
        this.network[0][1] = 0.0;
        this.network[0][2] = 0.0;
        this.network[1][0] = 1.0;
        this.network[1][1] = 1.0;
        this.network[1][2] = 1.0;
        for (n = 0; n < 3; ++n) {
            this.freq[n] = 0.00390625;
            this.bias[n] = 0.0;
        }
        for (n = 3; n < 256; ++n) {
            double[] dArray = this.network[n];
            dArray[0] = 256.0 * (double)(n - 3) / 253.0;
            dArray[1] = 256.0 * (double)(n - 3) / 253.0;
            dArray[2] = 256.0 * (double)(n - 3) / 253.0;
            this.freq[n] = 0.00390625;
            this.bias[n] = 0.0;
        }
    }

    private void altersingle(double d, int n, double d2, double d3, double d4) {
        double[] dArray = this.network[n];
        dArray[0] = dArray[0] - d * (dArray[0] - d2);
        dArray[1] = dArray[1] - d * (dArray[1] - d3);
        dArray[2] = dArray[2] - d * (dArray[2] - d4);
    }

    private void alterneigh(double d, int n, int n2, double d2, double d3, double d4) {
        int n3;
        int n4 = n2 - n;
        if (n4 < 2) {
            n4 = 2;
        }
        if ((n3 = n2 + n) > 256) {
            n3 = 256;
        }
        int n5 = n2 + 1;
        int n6 = n2 - 1;
        int n7 = 0;
        while (n5 < n3 || n6 > n4) {
            double[] dArray;
            double d5 = d * (double)(n * n - n7 * n7) / (double)(n * n);
            ++n7;
            if (n5 < n3) {
                dArray = this.network[n5];
                dArray[0] = dArray[0] - d5 * (dArray[0] - d2);
                dArray[1] = dArray[1] - d5 * (dArray[1] - d3);
                dArray[2] = dArray[2] - d5 * (dArray[2] - d4);
                ++n5;
            }
            if (n6 <= n4) continue;
            dArray = this.network[n6];
            dArray[0] = dArray[0] - d5 * (dArray[0] - d2);
            dArray[1] = dArray[1] - d5 * (dArray[1] - d3);
            dArray[2] = dArray[2] - d5 * (dArray[2] - d4);
            --n6;
        }
    }

    private int contest(double d, double d2, double d3) {
        int n;
        double d4;
        double d5 = d4 = 3.4028234663852886E38;
        int n2 = n = -1;
        for (int i = 3; i < 256; ++i) {
            double d6;
            double d7;
            double[] dArray = this.network[i];
            double d8 = dArray[0] - d;
            if (d8 < 0.0) {
                d8 = -d8;
            }
            if ((d7 = dArray[1] - d2) < 0.0) {
                d7 = -d7;
            }
            d8 += d7;
            d7 = dArray[2] - d3;
            if (d7 < 0.0) {
                d7 = -d7;
            }
            if ((d8 += d7) < d4) {
                d4 = d8;
                n = i;
            }
            if ((d6 = d8 - this.bias[i]) < d5) {
                d5 = d6;
                n2 = i;
            }
            int n3 = i;
            this.freq[n3] = this.freq[n3] - 9.765625E-4 * this.freq[i];
            int n4 = i;
            this.bias[n4] = this.bias[n4] + 1.0 * this.freq[i];
        }
        int n5 = n;
        this.freq[n5] = this.freq[n5] + 9.765625E-4;
        int n6 = n;
        this.bias[n6] = this.bias[n6] - 1.0;
        return n2;
    }

    private int specialFind(double d, double d2, double d3) {
        for (int i = 0; i < 3; ++i) {
            double[] dArray = this.network[i];
            if (dArray[0] != d || dArray[1] != d2 || dArray[2] != d3) continue;
            return i;
        }
        return -1;
    }

    private void learn(BufferedImage bufferedImage) {
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        int n3 = 2048;
        int n4 = 30 + (this.samplefac - 1) / 3;
        int n5 = n * n2;
        int n6 = n5 / this.samplefac;
        int n7 = n6 / 100;
        int n8 = 1024;
        int n9 = 0;
        int n10 = n3 >> 6;
        if (n10 <= 1) {
            n10 = 0;
        }
        System.out.println("beginning 1D learning: samplepixels=" + n6 + "  rad=" + n10);
        int n11 = 0;
        int n12 = 0;
        n11 = n5 % 499 != 0 ? 499 : (n5 % 491 != 0 ? 491 : (n5 % 487 != 0 ? 487 : 503));
        n9 = 0;
        while (n9 < n6) {
            int n13;
            int n14 = bufferedImage.getRGB(n12 % n2, n12 / n2);
            int n15 = n14 >> 16 & 0xFF;
            int n16 = n14 >> 8 & 0xFF;
            int n17 = n14 & 0xFF;
            double d = n17;
            double d2 = n16;
            double d3 = n15;
            if (n9 == 0) {
                this.network[2][0] = d;
                this.network[2][1] = d2;
                this.network[2][2] = d3;
            }
            int n18 = n13 = (n13 = this.specialFind(d, d2, d3)) < 0 ? this.contest(d, d2, d3) : n13;
            if (n13 >= 3) {
                double d4 = 1.0 * (double)n8 / 1024.0;
                this.altersingle(d4, n13, d, d2, d3);
                if (n10 > 0) {
                    this.alterneigh(d4, n10, n13, d, d2, d3);
                }
            }
            n12 += n11;
            while (n12 >= n5) {
                n12 -= n5;
            }
            if (++n9 % n7 != 0) continue;
            n8 -= n8 / n4;
            if ((n10 = (n3 -= n3 / 30) >> 6) > 1) continue;
            n10 = 0;
        }
        System.out.println("finished 1D learning: final alpha=" + 1.0 * (double)n8 / 1024.0 + "!");
    }

    private void fix() {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n = (int)(0.5 + this.network[i][j]);
                if (n < 0) {
                    n = 0;
                }
                if (n > 255) {
                    n = 255;
                }
                this.colormap[i][j] = n;
            }
            this.colormap[i][3] = i;
        }
    }

    private void inxbuild() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            int n4;
            int[] nArray = this.colormap[n];
            int[] nArray2 = null;
            int n5 = n;
            int n6 = nArray[1];
            for (n4 = n + 1; n4 < 256; ++n4) {
                nArray2 = this.colormap[n4];
                if (nArray2[1] >= n6) continue;
                n5 = n4;
                n6 = nArray2[1];
            }
            nArray2 = this.colormap[n5];
            if (n != n5) {
                n4 = nArray2[0];
                nArray2[0] = nArray[0];
                nArray[0] = n4;
                n4 = nArray2[1];
                nArray2[1] = nArray[1];
                nArray[1] = n4;
                n4 = nArray2[2];
                nArray2[2] = nArray[2];
                nArray[2] = n4;
                n4 = nArray2[3];
                nArray2[3] = nArray[3];
                nArray[3] = n4;
            }
            if (n6 == n2) continue;
            this.netindex[n2] = n3 + n >> 1;
            for (n4 = n2 + 1; n4 < n6; ++n4) {
                this.netindex[n4] = n;
            }
            n2 = n6;
            n3 = n;
        }
        this.netindex[n2] = n3 + 255 >> 1;
        for (n = n2 + 1; n < 256; ++n) {
            this.netindex[n] = 255;
        }
    }

    private int inxsearch(int n, int n2, int n3) {
        int n4 = 1000;
        int n5 = -1;
        int n6 = this.netindex[n2];
        int n7 = n6 - 1;
        while (n6 < 256 || n7 >= 0) {
            int n8;
            int n9;
            int[] nArray;
            if (n6 < 256) {
                nArray = this.colormap[n6];
                n9 = nArray[1] - n2;
                if (n9 >= n4) {
                    n6 = 256;
                } else {
                    if (n9 < 0) {
                        n9 = -n9;
                    }
                    if ((n8 = nArray[0] - n3) < 0) {
                        n8 = -n8;
                    }
                    if ((n9 += n8) < n4) {
                        n8 = nArray[2] - n;
                        if (n8 < 0) {
                            n8 = -n8;
                        }
                        if ((n9 += n8) < n4) {
                            n4 = n9;
                            n5 = n6;
                        }
                    }
                    ++n6;
                }
            }
            if (n7 < 0) continue;
            nArray = this.colormap[n7];
            n9 = n2 - nArray[1];
            if (n9 >= n4) {
                n7 = -1;
                continue;
            }
            if (n9 < 0) {
                n9 = -n9;
            }
            if ((n8 = nArray[0] - n3) < 0) {
                n8 = -n8;
            }
            if ((n9 += n8) < n4) {
                n8 = nArray[2] - n;
                if (n8 < 0) {
                    n8 = -n8;
                }
                if ((n9 += n8) < n4) {
                    n4 = n9;
                    n5 = n7;
                }
            }
            --n7;
        }
        return n5;
    }
}

