/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain.memapplet;

import java.applet.Applet;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerDevice;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;
import uk.co.mmscomputing.device.twain.TwainIOMetadata;
import uk.co.mmscomputing.device.twain.TwainSource;
import uk.co.mmscomputing.device.twain.TwainTransfer;

public class TwainMemApplet
extends Applet
implements ActionListener,
ScannerListener {
    static TwainMemApplet app;
    static int transferCount;
    int twainimgtype = 2;
    File dir = null;
    Scanner scanner;
    Button acquireButton;
    Button selectButton;

    public void init() {
        this.setLayout(new GridLayout(0, 2));
        this.selectButton = new Button("select");
        this.add(this.selectButton);
        this.selectButton.addActionListener(this);
        this.acquireButton = new Button("acquire");
        this.add(this.acquireButton);
        this.acquireButton.addActionListener(this);
        this.scanner = Scanner.getDevice();
        this.scanner.addListener(this);
        try {
            File file = new File(System.getProperty("user.home"));
            this.dir = new File(file, "My Documents");
            if (!this.dir.exists()) {
                this.dir = file;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.acquireButton) {
                this.scanner.acquire();
            } else if (actionEvent.getSource() == this.selectButton) {
                this.scanner.select();
            }
        }
        catch (ScannerIOException scannerIOException) {
            scannerIOException.printStackTrace();
        }
    }

    public void update(ScannerIOMetadata.Type type, ScannerIOMetadata scannerIOMetadata) {
        if (type.equals(ScannerIOMetadata.MEMORY)) {
            try {
                if (scannerIOMetadata instanceof TwainIOMetadata) {
                    TwainIOMetadata twainIOMetadata = (TwainIOMetadata)scannerIOMetadata;
                    TwainTransfer.MemoryTransfer.Info info = twainIOMetadata.getMemory();
                    byte[] byArray = info.getBuffer();
                    int n = info.getWidth();
                    int n2 = info.getHeight();
                    BufferedImage bufferedImage = null;
                    if (this.twainimgtype == 0) {
                        n = info.getBytesPerRow() * 8;
                        bufferedImage = new BufferedImage(n, n2, 12);
                        byte[] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                    } else if (this.twainimgtype == 1) {
                        n = info.getBytesPerRow();
                        bufferedImage = new BufferedImage(n, n2, 10);
                        byte[] byArray3 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                        System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
                    } else if (this.twainimgtype == 2) {
                        bufferedImage = new BufferedImage(n, n2, 1);
                        int n3 = info.getBytesPerRow();
                        int n4 = 0;
                        int n5 = 0;
                        for (int i = 0; i < n2; ++i) {
                            for (int j = 0; j < n; ++j) {
                                int n6 = byArray[n5++] & 0xFF;
                                int n7 = byArray[n5++] & 0xFF;
                                int n8 = byArray[n5++] & 0xFF;
                                bufferedImage.setRGB(j, i, n6 << 16 | n7 << 8 | n8);
                            }
                            n5 = n4 += n3;
                        }
                    }
                    String string = "image" + transferCount + ".png";
                    File file = this.dir != null ? new File(this.dir, string) : new File(string);
                    System.out.println(file.getCanonicalPath());
                    ImageIO.write((RenderedImage)bufferedImage, "png", file);
                    ++transferCount;
                    System.out.println("info = " + info.toString() + "\n");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (type.equals(ScannerIOMetadata.NEGOTIATE)) {
            transferCount = 0;
            ScannerDevice scannerDevice = scannerIOMetadata.getDevice();
            try {
                scannerDevice.setShowUserInterface(false);
                scannerDevice.setShowProgressBar(true);
                scannerDevice.setResolution(100.0);
                if (scannerIOMetadata instanceof TwainIOMetadata) {
                    TwainSource twainSource = ((TwainIOMetadata)scannerIOMetadata).getSource();
                    twainSource.setCapability(257, this.twainimgtype);
                    System.out.println(twainSource.getCapability(257).toString());
                    twainSource.setXferMech(2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (type.equals(ScannerIOMetadata.STATECHANGE)) {
            System.err.println(scannerIOMetadata.getStateStr());
        } else if (type.equals(ScannerIOMetadata.EXCEPTION)) {
            scannerIOMetadata.getException().printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            app = new TwainMemApplet();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        transferCount = 0;
    }
}

