/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.device.scanner.ScannerDevice;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.twain.TwainCapability;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainDefaultTransferFactory;
import uk.co.mmscomputing.device.twain.TwainFailureException;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.TwainITransfer;
import uk.co.mmscomputing.device.twain.TwainITransferFactory;
import uk.co.mmscomputing.device.twain.TwainIdentity;
import uk.co.mmscomputing.device.twain.TwainImageLayout;
import uk.co.mmscomputing.device.twain.TwainResultException;
import uk.co.mmscomputing.device.twain.TwainSourceManager;
import uk.co.mmscomputing.device.twain.TwainUserCancelException;
import uk.co.mmscomputing.device.twain.jtwain;

public class TwainSource
extends TwainIdentity
implements TwainConstants,
ScannerDevice {
    private boolean busy;
    private int state;
    private long hWnd;
    private int showUI = 1;
    private int modalUI = 0;
    private int iff = 2;
    private TwainITransferFactory transferFactory;
    private boolean userCancelled;
    private Semaphore tw20Semaphore = null;
    private boolean tw20HaveImage = false;

    TwainSource(TwainSourceManager twainSourceManager, long l, boolean bl) {
        super(twainSourceManager);
        this.hWnd = l;
        this.busy = bl;
        this.state = 3;
        this.userCancelled = false;
        this.transferFactory = new TwainDefaultTransferFactory();
    }

    byte[] getIdentity() {
        return this.identity;
    }

    public boolean isBusy() {
        return this.busy;
    }

    void setBusy(boolean bl) {
        this.busy = bl;
        jtwain.signalStateChange(this);
    }

    public int getState() {
        return this.state;
    }

    void setState(int n) {
        this.state = n;
        jtwain.signalStateChange(this);
    }

    public void setCancel(boolean bl) {
        this.userCancelled = bl;
    }

    public boolean getCancel() {
        return this.userCancelled;
    }

    void checkState(int n) throws TwainIOException {
        if (this.state == n) {
            return;
        }
        throw new TwainIOException(this.getClass().getName() + ".checkState:\n\tSource not in state " + n + " but in state " + this.state + ".");
    }

    int getConditionCode() throws TwainIOException {
        byte[] byArray = new byte[4];
        int n = jtwain.callSource(this.identity, 1, 8, 1, byArray);
        if (n != 0) {
            throw new TwainResultException("Cannot retrieve twain source's status.", n);
        }
        return jtwain.getINT16(byArray, 0);
    }

    private void checkrc(int n) throws TwainIOException {
        switch (n) {
            case 0: {
                return;
            }
            case 1: {
                throw TwainFailureException.create(this.getConditionCode());
            }
            case 2: {
                throw new TwainResultException.CheckStatus();
            }
            case 3: {
                throw new TwainResultException.Cancel();
            }
            case 4: {
                return;
            }
            case 5: {
                throw new TwainResultException.NotDSEvent();
            }
            case 6: {
                throw new TwainResultException.TransferDone();
            }
            case 7: {
                throw new TwainResultException.EndOfList();
            }
            case 8: {
                throw new TwainResultException.InfoNotSupported();
            }
            case 9: {
                throw new TwainResultException.DataNotAvailable();
            }
        }
        System.err.println(this.getClass().getName() + ".checkrc\n\trc=" + n);
        throw new TwainResultException("Failed to call source.", n);
    }

    public void call(int n, int n2, int n3, byte[] byArray) throws TwainIOException {
        this.checkrc(jtwain.callSource(this.identity, n, n2, n3, byArray));
    }

    private void setCallbackProcedure() throws TwainIOException {
        byte[] byArray = new byte[jtwain.getPtrSize() == 4 ? 10 : 14];
        int n = jtwain.setPtr(byArray, 0, jtwain.getCallBackMethod());
        jtwain.setINT32(byArray, n, 0);
        jtwain.setINT16(byArray, n += 4, 0);
        this.call(1, 16, 2306, byArray);
    }

    void open() throws TwainIOException {
        super.open();
        if (this.isTwain20Source()) {
            try {
                this.setCallbackProcedure();
            }
            catch (Exception exception) {
                this.maskTwain20Source();
                System.out.println("3\b" + this.getClass().getName() + ".open:\n\tCannot set twain 2.0 callback method.");
                System.err.println(this.getClass().getName() + ".open:\n\tCannot set twain 2.0 callback method.");
            }
        }
    }

    public TwainCapability[] getCapabilities() throws TwainIOException {
        return TwainCapability.getCapabilities(this);
    }

    public TwainCapability getCapability(int n) throws TwainIOException {
        return new TwainCapability(this, n);
    }

    public TwainCapability getCapability(int n, int n2) throws TwainIOException {
        return new TwainCapability(this, n, n2);
    }

    public TwainITransferFactory getTransferFactory() {
        return this.transferFactory;
    }

    public void setTransferFactory(TwainITransferFactory twainITransferFactory) {
        if (twainITransferFactory == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ".setTransferFactory\n\tTwain transfer factory cannot be null.");
        }
        this.transferFactory = twainITransferFactory;
    }

    public void setShowUI(boolean bl) {
        this.showUI = bl ? 1 : 0;
    }

    public boolean isModalUI() {
        return this.modalUI == 1;
    }

    public void setCapability(int n, boolean bl) throws ScannerIOException {
        TwainCapability twainCapability = this.getCapability(n, 2);
        if (twainCapability.booleanValue() != bl) {
            twainCapability.setCurrentValue(bl);
            if (this.getCapability(n).booleanValue() != bl) {
                throw new ScannerIOException(this.getClass().getName() + ".setCapability:\n\tCannot set capability " + TwainCapability.getCapName(n) + " to " + bl);
            }
        }
    }

    public void setCapability(int n, int n2) throws ScannerIOException {
        TwainCapability twainCapability = this.getCapability(n, 2);
        if (twainCapability.intValue() != n2) {
            twainCapability.setCurrentValue(n2);
            if (this.getCapability(n).intValue() != n2) {
                throw new ScannerIOException(this.getClass().getName() + ".setCapability:\n\tCannot set capability " + TwainCapability.getCapName(n) + " to " + n2);
            }
        }
    }

    public void setCapability(int n, double d) throws ScannerIOException {
        TwainCapability twainCapability = this.getCapability(n, 2);
        if (twainCapability.doubleValue() != d) {
            twainCapability.setCurrentValue(d);
            if (this.getCapability(n).doubleValue() != d) {
                throw new ScannerIOException(this.getClass().getName() + ".setCapability:\n\tCannot set capability " + TwainCapability.getCapName(n) + " to " + d);
            }
        }
    }

    public boolean isUIControllable() {
        try {
            return this.getCapability(4110).booleanValue();
        }
        catch (Exception exception) {
            jtwain.signalException(this.getClass().getName() + ".isUIControllable:\n\t" + exception);
            return false;
        }
    }

    public boolean isDeviceOnline() {
        try {
            return this.getCapability(4111).booleanValue();
        }
        catch (Exception exception) {
            jtwain.signalException(this.getClass().getName() + ".isOnline:\n\t" + exception);
            return true;
        }
    }

    public void setShowUserInterface(boolean bl) throws ScannerIOException {
        this.setShowUI(bl);
    }

    public void setShowProgressBar(boolean bl) throws ScannerIOException {
        this.setCapability(4107, bl);
    }

    public void setResolution(double d) throws ScannerIOException {
        this.setCapability(258, 0);
        this.setCapability(4376, d);
        this.setCapability(4377, d);
    }

    public void setRegionOfInterest(int n, int n2, int n3, int n4) throws ScannerIOException {
        if (n == -1 && n2 == -1 && n3 == -1 && n4 == -1) {
            new TwainImageLayout(this).reset();
        } else {
            this.setCapability(258, 5);
            TwainImageLayout twainImageLayout = new TwainImageLayout(this);
            twainImageLayout.get();
            twainImageLayout.setLeft(n);
            twainImageLayout.setTop(n2);
            twainImageLayout.setRight(n + n3);
            twainImageLayout.setBottom(n2 + n4);
            twainImageLayout.set();
        }
    }

    public void setRegionOfInterest(double d, double d2, double d3, double d4) throws ScannerIOException {
        if (d == -1.0 && d2 == -1.0 && d3 == -1.0 && d4 == -1.0) {
            new TwainImageLayout(this).reset();
        } else {
            this.setCapability(258, 1);
            TwainImageLayout twainImageLayout = new TwainImageLayout(this);
            twainImageLayout.get();
            twainImageLayout.setLeft(d / 10.0);
            twainImageLayout.setTop(d2 / 10.0);
            twainImageLayout.setRight((d + d3) / 10.0);
            twainImageLayout.setBottom((d2 + d4) / 10.0);
            twainImageLayout.set();
        }
    }

    public void select(String string) throws ScannerIOException {
        this.checkState(3);
        TwainSourceManager twainSourceManager = jtwain.getSourceManager();
        try {
            TwainIdentity twainIdentity = new TwainIdentity(twainSourceManager);
            twainIdentity.getFirst();
            while (true) {
                if (twainIdentity.getProductName().equals(string)) {
                    System.arraycopy(twainIdentity.identity, 0, this.identity, 0, this.identity.length);
                    break;
                }
                twainIdentity.getNext();
            }
        }
        catch (TwainResultException.EndOfList endOfList) {
            throw new TwainIOException(this.getClass().getName() + ".select(String name)\n\tCannot find twain data source: '" + string + "'");
        }
    }

    void enable() throws TwainIOException {
        this.checkState(4);
        jtwain.negotiateCapabilities(this);
        if (this.getState() < 4) {
            return;
        }
        int n = new TwainCapability.XferMech(this).intValue();
        if (n != 0 && n == 1) {
            try {
                this.iff = this.getCapability(4364).intValue();
            }
            catch (Exception exception) {
                this.iff = 2;
            }
        }
        if (this.isTwain20Source()) {
            this.tw20Semaphore = new Semaphore(0, true);
            this.tw20HaveImage = false;
        }
        byte[] byArray = null;
        try {
            byArray = new byte[jtwain.getPtrSize() == 4 ? 8 : 12];
            jtwain.setINT16(byArray, 0, this.showUI);
            jtwain.setINT16(byArray, 2, this.modalUI);
            jtwain.setPtr(byArray, 4, this.hWnd);
            this.call(1, 9, 1282, byArray);
            this.modalUI = jtwain.getINT16(byArray, 2);
            this.setState(5);
        }
        catch (TwainResultException.CheckStatus checkStatus) {
            this.setState(5);
            this.showUI = ~this.showUI & 1;
        }
        catch (TwainResultException.Cancel cancel) {
            this.disable();
            this.close();
        }
        if (this.isTwain20Source()) {
            try {
                this.tw20Semaphore.tryAcquire(60000L, TimeUnit.MILLISECONDS);
                this.tw20Semaphore.release();
                if (this.tw20HaveImage) {
                    this.transferImage();
                } else {
                    System.out.println("9\b" + this.getClass().getName() + ".enable:\n\tscan timed out. Close data source.");
                    System.err.println(this.getClass().getName() + ".enable:\n\tscan timed out Close data source.");
                }
            }
            catch (TwainIOException twainIOException) {
                System.out.println("9\b" + this.getClass().getName() + ".enable:\n\t" + twainIOException);
                System.err.println(this.getClass().getName() + ".enable:\n\t" + twainIOException);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("9\b" + this.getClass().getName() + ".enable:\n\tscan interrupted");
                System.err.println(this.getClass().getName() + ".enable:\n\tscan interrupted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(TwainITransfer twainITransfer) throws TwainIOException {
        try {
            byte[] byArray = new byte[6];
            do {
                this.setState(6);
                jtwain.setINT16(byArray, 0, -1);
                try {
                    twainITransfer.setCancel(this.userCancelled);
                    twainITransfer.initiate();
                }
                catch (TwainResultException.TransferDone transferDone) {
                    this.setState(7);
                    twainITransfer.finish();
                    this.call(1, 5, 1793, byArray);
                    if (jtwain.getINT16(byArray, 0) != 0) continue;
                    this.setState(5);
                }
                catch (TwainUserCancelException twainUserCancelException) {
                    this.call(1, 5, 7, byArray);
                    this.setState(5);
                }
                catch (TwainResultException.Cancel cancel) {
                    twainITransfer.cancel();
                    this.call(1, 5, 1793, byArray);
                    if (jtwain.getINT16(byArray, 0) > 0) {
                        this.call(1, 5, 7, byArray);
                    }
                    this.setState(5);
                }
                catch (TwainFailureException twainFailureException) {
                    jtwain.signalException(this.getClass().getName() + ".transfer:\n\t" + twainFailureException);
                    this.call(1, 5, 1793, byArray);
                    if (jtwain.getINT16(byArray, 0) > 0) {
                        this.call(1, 5, 7, byArray);
                    }
                    this.setState(5);
                }
                finally {
                    twainITransfer.cleanup();
                }
            } while (jtwain.getINT16(byArray, 0) != 0);
        }
        finally {
            if (this.userCancelled || this.showUI == 0) {
                this.userCancelled = false;
                this.disable();
                this.close();
            }
        }
    }

    void transferImage() throws TwainIOException {
        switch (this.getXferMech()) {
            case 0: {
                this.transfer(this.transferFactory.createNativeTransfer(this));
                break;
            }
            case 1: {
                this.transfer(this.transferFactory.createFileTransfer(this));
                break;
            }
            case 2: {
                this.transfer(this.transferFactory.createMemoryTransfer(this));
                break;
            }
            default: {
                System.out.println(this.getClass().getName() + ".transferImage:\n\tDo not support this transfer mode: " + this.getXferMech());
                System.err.println(this.getClass().getName() + ".transferImage:\n\tDo not support this transfer mode: " + this.getXferMech());
            }
        }
    }

    void disable() throws TwainIOException {
        if (this.state < 5) {
            return;
        }
        byte[] byArray = new byte[jtwain.getPtrSize() == 4 ? 8 : 12];
        jtwain.setINT16(byArray, 0, -1);
        jtwain.setINT16(byArray, 2, 0);
        jtwain.setPtr(byArray, 4, this.hWnd);
        this.call(1, 9, 1281, byArray);
        this.setState(4);
    }

    void close() throws TwainIOException {
        if (this.state != 4) {
            return;
        }
        this.call(1, 3, 1026, this.identity);
        this.busy = false;
        this.setState(3);
    }

    int callback(int n, int n2, int n3, long l) throws TwainIOException {
        switch (n3) {
            case 257: {
                this.tw20HaveImage = true;
                this.tw20Semaphore.release();
                break;
            }
            case 258: 
            case 259: {
                System.err.println("MSG_CLOSEDSOK,MSG_CLOSEDSREQ in callback routine");
                this.tw20HaveImage = false;
                this.tw20Semaphore.release();
                break;
            }
            case 0: 
            case 260: {
                break;
            }
            default: {
                System.err.println("9\b" + this.getClass().getName() + ".callback:\n\tUnknown message in Twain 2.0 callback routine");
                return 1;
            }
        }
        return 0;
    }

    int handleGetMessage(long l) throws TwainIOException {
        if (this.state < 5) {
            return 5;
        }
        try {
            byte[] byArray = new byte[jtwain.getPtrSize() == 4 ? 6 : 10];
            int n = jtwain.setPtr(byArray, 0, l);
            jtwain.setINT16(byArray, n, 0);
            this.call(1, 2, 1537, byArray);
            int n2 = jtwain.getINT16(byArray, n);
            switch (n2) {
                case 257: {
                    this.transferImage();
                    break;
                }
                case 258: 
                case 259: {
                    this.disable();
                    this.close();
                    break;
                }
            }
            return 4;
        }
        catch (TwainResultException.NotDSEvent notDSEvent) {
            return 5;
        }
    }

    public int getXferMech() throws TwainIOException {
        return new TwainCapability.XferMech(this).intValue();
    }

    public void setXferMech(int n) {
        try {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    n = 0;
                }
            }
            TwainCapability twainCapability = this.getCapability(259, 2);
            if (twainCapability.intValue() != n) {
                twainCapability.setCurrentValue(n);
                if (this.getCapability(259).intValue() != n) {
                    jtwain.signalException(this.getClass().getName() + ".setXferMech:\n\tCannot change transfer mechanism to mode=" + n);
                }
            }
        }
        catch (TwainIOException twainIOException) {
            jtwain.signalException(this.getClass().getName() + ".setXferMech:\n\t" + twainIOException);
        }
    }

    int getImageFileFormat() {
        return this.iff;
    }

    public void setImageFileFormat(int n) {
        try {
            switch (n) {
                case 0: 
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    n = 2;
                }
            }
            TwainCapability twainCapability = this.getCapability(4364, 2);
            if (twainCapability.intValue() != n) {
                twainCapability.setCurrentValue(n);
                if (this.getCapability(4364).intValue() != n) {
                    jtwain.signalException(this.getClass().getName() + ".setImageFileFormat:\n\tCannot change file format to format=" + n);
                }
            }
        }
        catch (Exception exception) {
            jtwain.signalException(this.getClass().getName() + ".setImageFileFormat:\n\t" + exception);
        }
    }
}

