/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.TwainIOMetadata;
import uk.co.mmscomputing.device.twain.TwainIdentity;
import uk.co.mmscomputing.device.twain.TwainPanel;
import uk.co.mmscomputing.device.twain.TwainSource;
import uk.co.mmscomputing.device.twain.TwainTransfer;
import uk.co.mmscomputing.device.twain.jtwain;

public class TwainScanner
extends Scanner
implements TwainConstants {
    public TwainScanner() {
        this.metadata = new TwainIOMetadata();
        jtwain.setScanner(this);
    }

    public void select() throws ScannerIOException {
        jtwain.select(this);
    }

    public TwainIdentity[] getIdentities() {
        Vector vector = new Vector();
        try {
            jtwain.getIdentities(this, vector);
        }
        catch (Exception exception) {
            this.metadata.setException(exception);
            this.fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
        }
        return vector.toArray(new TwainIdentity[vector.size()]);
    }

    public String[] getDeviceNames() throws ScannerIOException {
        Vector vector = new Vector();
        jtwain.getIdentities(this, vector);
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TwainIdentity twainIdentity = (TwainIdentity)enumeration.nextElement();
            stringArray[n] = twainIdentity.getProductName();
            ++n;
        }
        return stringArray;
    }

    public void select(String string) throws ScannerIOException {
        jtwain.select(this, string);
    }

    public String getSelectedDeviceName() throws ScannerIOException {
        return jtwain.getSource().getProductName();
    }

    public void acquire() throws ScannerIOException {
        jtwain.acquire(this);
    }

    public void setCancel(boolean bl) throws ScannerIOException {
        jtwain.setCancel(this, bl);
    }

    void setImage(BufferedImage bufferedImage) {
        try {
            this.metadata.setImage(bufferedImage);
            this.fireListenerUpdate(ScannerIOMetadata.ACQUIRED);
        }
        catch (Exception exception) {
            this.metadata.setException(exception);
            this.fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
        }
    }

    void setImage(File file) {
        try {
            this.metadata.setFile(file);
            this.fireListenerUpdate(ScannerIOMetadata.FILE);
        }
        catch (Exception exception) {
            this.metadata.setException(exception);
            this.fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
        }
    }

    void setImageBuffer(TwainTransfer.MemoryTransfer.Info info) {
        try {
            ((TwainIOMetadata)this.metadata).setMemory(info);
            this.fireListenerUpdate(ScannerIOMetadata.MEMORY);
        }
        catch (Exception exception) {
            this.metadata.setException(exception);
            this.fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
        }
    }

    protected void negotiateCapabilities(TwainSource twainSource) {
        ((TwainIOMetadata)this.metadata).setSource(twainSource);
        this.fireListenerUpdate(ScannerIOMetadata.NEGOTIATE);
        if (this.metadata.getCancel()) {
            try {
                twainSource.close();
            }
            catch (Exception exception) {
                this.metadata.setException(exception);
                this.fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
            }
        }
    }

    void setState(TwainSource twainSource) {
        this.metadata.setState(twainSource.getState());
        ((TwainIOMetadata)this.metadata).setSource(twainSource);
        this.fireListenerUpdate(ScannerIOMetadata.STATECHANGE);
    }

    void signalInfo(String string, int n) {
        this.metadata.setInfo(string + " [0x" + Integer.toHexString(n) + "]");
        this.fireListenerUpdate(ScannerIOMetadata.INFO);
    }

    void signalException(String string) {
        TwainIOException twainIOException = new TwainIOException(this.getClass().getName() + ".setException:\n    " + string);
        this.metadata.setException(twainIOException);
        this.fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
    }

    public boolean isAPIInstalled() {
        return jtwain.isInstalled();
    }

    public JComponent getScanGUI() throws ScannerIOException {
        return this.getScanGUI(4);
    }

    public JComponent getScanGUI(int n) throws ScannerIOException {
        return new TwainPanel(this, n);
    }

    public static Scanner getDevice() {
        return new TwainScanner();
    }
}

