/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import uk.co.mmscomputing.device.twain.TwainIOException;

public class TwainResultException
extends TwainIOException {
    private int rc = -1;

    public TwainResultException(String string, int n) {
        super(string + "\n\trc=" + n);
        this.rc = n;
    }

    public int getResultCode() {
        return this.rc;
    }

    public static class DataNotAvailable
    extends TwainResultException {
        public DataNotAvailable() {
            super("Info not supported.", 9);
        }
    }

    public static class InfoNotSupported
    extends TwainResultException {
        public InfoNotSupported() {
            super("Info not supported.", 8);
        }
    }

    public static class EndOfList
    extends TwainResultException {
        public EndOfList() {
            super("End of List.", 7);
        }
    }

    public static class TransferDone
    extends TwainResultException {
        public TransferDone() {
            super("Image transfer done.", 6);
        }
    }

    public static class NotDSEvent
    extends TwainResultException {
        public NotDSEvent() {
            super("No data source event.", 5);
        }
    }

    public static class DSEvent
    extends TwainResultException {
        public DSEvent() {
            super("Data source event.", 4);
        }
    }

    public static class Cancel
    extends TwainResultException {
        public Cancel() {
            super("User cancelled twain operation.", 3);
        }
    }

    public static class CheckStatus
    extends TwainResultException {
        public CheckStatus() {
            super("Source could not fulfill request.", 2);
        }
    }
}

