/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.TwainSource;
import uk.co.mmscomputing.device.twain.jtwain;

public class TwainImageLayout
implements TwainConstants {
    TwainSource source;
    byte[] buf = new byte[28];

    public TwainImageLayout(TwainSource twainSource) {
        this.source = twainSource;
    }

    public void get() throws TwainIOException {
        this.source.call(2, 258, 1, this.buf);
    }

    public void getDefault() throws TwainIOException {
        this.source.call(2, 258, 3, this.buf);
    }

    public void set() throws TwainIOException {
        this.source.call(2, 258, 6, this.buf);
    }

    public void reset() throws TwainIOException {
        this.source.call(2, 258, 7, this.buf);
    }

    public double getLeft() {
        return jtwain.getFIX32(this.buf, 0);
    }

    public void setLeft(double d) {
        jtwain.setFIX32(this.buf, 0, d);
    }

    public double getTop() {
        return jtwain.getFIX32(this.buf, 4);
    }

    public void setTop(double d) {
        jtwain.setFIX32(this.buf, 4, d);
    }

    public double getRight() {
        return jtwain.getFIX32(this.buf, 8);
    }

    public void setRight(double d) {
        jtwain.setFIX32(this.buf, 8, d);
    }

    public double getBottom() {
        return jtwain.getFIX32(this.buf, 12);
    }

    public void setBottom(double d) {
        jtwain.setFIX32(this.buf, 12, d);
    }

    public int getDocumentNumber() {
        return jtwain.getINT32(this.buf, 16);
    }

    public void setDocumentNumber(int n) {
        jtwain.setINT32(this.buf, 16, n);
    }

    public int getPageNumber() {
        return jtwain.getINT32(this.buf, 20);
    }

    public void setPageNumber(int n) {
        jtwain.setINT32(this.buf, 20, n);
    }

    public int getFrameNumber() {
        return jtwain.getINT32(this.buf, 24);
    }

    public void setFrameNumber(int n) {
        jtwain.setINT32(this.buf, 24, n);
    }

    public String toString() {
        String string = "TwainImageLayout\n";
        string = string + "\tleft   =" + this.getLeft() + "\n";
        string = string + "\ttop    =" + this.getTop() + "\n";
        string = string + "\tright  =" + this.getRight() + "\n";
        string = string + "\tbottom =" + this.getBottom() + "\n";
        string = string + "\tdocument number =" + this.getDocumentNumber() + "\n";
        string = string + "\tpage number     =" + this.getPageNumber() + "\n";
        string = string + "\tframe number    =" + this.getFrameNumber() + "\n";
        return string;
    }
}

