/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerDevice;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;

public class TwainExample
implements ScannerListener {
    static TwainExample app;
    Scanner scanner = Scanner.getDevice();

    public TwainExample(String[] stringArray) throws ScannerIOException {
        this.scanner.addListener(this);
        this.scanner.acquire();
    }

    public void update(ScannerIOMetadata.Type type, ScannerIOMetadata scannerIOMetadata) {
        if (type.equals(ScannerIOMetadata.ACQUIRED)) {
            BufferedImage bufferedImage = scannerIOMetadata.getImage();
            System.out.println("Have an image now!");
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", new File("mmsc_image.png"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (type.equals(ScannerIOMetadata.NEGOTIATE)) {
            ScannerDevice scannerDevice = scannerIOMetadata.getDevice();
        } else if (type.equals(ScannerIOMetadata.STATECHANGE)) {
            System.err.println(scannerIOMetadata.getStateStr());
            if (scannerIOMetadata.isFinished()) {
                System.exit(0);
            }
        } else if (type.equals(ScannerIOMetadata.EXCEPTION)) {
            scannerIOMetadata.getException().printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            app = new TwainExample(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

