/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.twain;

import java.awt.geom.Rectangle2D;
import uk.co.mmscomputing.device.twain.TwainConstants;
import uk.co.mmscomputing.device.twain.TwainIOException;
import uk.co.mmscomputing.device.twain.jtwain;

public abstract class TwainContainer
implements TwainConstants {
    protected int cap;
    protected int type;
    static String[] hexs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    TwainContainer(int n, byte[] byArray) {
        this.cap = n;
        this.type = jtwain.getINT16(byArray, 0);
    }

    TwainContainer(int n, int n2) {
        this.cap = n;
        this.type = n2;
    }

    public int getCapabilityId() {
        return this.cap;
    }

    abstract int getType();

    abstract byte[] getBytes();

    public int getItemType() {
        return this.type;
    }

    public abstract Object[] getItems();

    private boolean booleanValue(Object object) throws TwainIOException {
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new TwainIOException(this.getClass().getName() + ".booleanValue:\n\tUnsupported data type: " + object.getClass().getName());
    }

    private int intValue(Object object) throws TwainIOException {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new TwainIOException(this.getClass().getName() + ".intValue:\n\tCannot convert string [\"" + string + "\"] to int.");
            }
        }
        throw new TwainIOException(this.getClass().getName() + ".intValue:\n\tUnsupported data type: " + object.getClass().getName());
    }

    private double doubleValue(Object object) throws TwainIOException {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Double.parseDouble(string);
            }
            catch (Exception exception) {
                throw new TwainIOException(this.getClass().getName() + ".doubleValue:\n\tCannot convert string [\"" + string + "\"] to double.");
            }
        }
        throw new TwainIOException(this.getClass().getName() + ".doubleValue:\n\tUnsupported data type: " + object.getClass().getName());
    }

    public abstract Object getCurrentValue() throws TwainIOException;

    public boolean booleanValue() throws TwainIOException {
        return this.booleanValue(this.getCurrentValue());
    }

    public int intValue() throws TwainIOException {
        return this.intValue(this.getCurrentValue());
    }

    public double doubleValue() throws TwainIOException {
        return this.doubleValue(this.getCurrentValue());
    }

    public abstract void setCurrentValue(Object var1) throws TwainIOException;

    public void setCurrentValue(boolean bl) throws TwainIOException {
        this.setCurrentValue(new Boolean(bl));
    }

    public void setCurrentValue(int n) throws TwainIOException {
        this.setCurrentValue(new Integer(n));
    }

    public void setCurrentValue(double d) throws TwainIOException {
        this.setCurrentValue(new Double(d));
    }

    public abstract Object getDefaultValue() throws TwainIOException;

    public boolean booleanDefaultValue() throws TwainIOException {
        return this.booleanValue(this.getDefaultValue());
    }

    public int intDefaultValue() throws TwainIOException {
        return this.intValue(this.getDefaultValue());
    }

    public double doubleDefaultValue() throws TwainIOException {
        return this.doubleValue(this.getDefaultValue());
    }

    public abstract void setDefaultValue(Object var1) throws TwainIOException;

    public void setDefaultValue(boolean bl) throws TwainIOException {
        this.setDefaultValue(new Boolean(bl));
    }

    public void setDefaultValue(int n) throws TwainIOException {
        this.setDefaultValue(new Integer(n));
    }

    public void setDefaultValue(double d) throws TwainIOException {
        this.setDefaultValue(new Double(d));
    }

    protected Object get32BitObjectAt(byte[] byArray, int n) {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                return new Integer(jtwain.getINT32(byArray, n));
            }
            case 3: {
                return new Integer(jtwain.getINT32(byArray, n) & 0xFF);
            }
            case 4: {
                return new Integer(jtwain.getINT32(byArray, n) & 0xFFFF);
            }
            case 5: {
                return new Long((long)jtwain.getINT32(byArray, n) & 0xFFFFFFFFL);
            }
            case 6: {
                return new Boolean(jtwain.getINT32(byArray, n) != 0);
            }
            case 7: {
                return new Double(jtwain.getFIX32(byArray, n));
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return new Integer(jtwain.getINT32(byArray, n));
            }
        }
        new TwainIOException(this.getClass().getName() + ".get32BitObjectAt:\n\tUnsupported type = " + this.type).printStackTrace();
        return null;
    }

    protected void set32BitObjectAt(byte[] byArray, int n, Object object) {
        boolean bl = false;
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            if (this.type == 7) {
                jtwain.setFIX32(byArray, n, n2);
            } else if (this.type == 6) {
                jtwain.setINT32(byArray, n, n2 == 0 ? 0 : 1);
            } else {
                jtwain.setINT32(byArray, n, n2);
            }
        } else if (object instanceof Double) {
            double d = (Double)object;
            if (this.type == 7) {
                jtwain.setFIX32(byArray, n, d);
            } else if (this.type == 6) {
                jtwain.setINT32(byArray, n, d == 0.0 ? 0 : 1);
            } else {
                jtwain.setINT32(byArray, n, (int)d);
            }
        } else if (object instanceof Boolean) {
            int n3;
            int n4 = n3 = (Boolean)object != false ? 1 : 0;
            if (this.type == 7) {
                jtwain.setFIX32(byArray, n, n3);
            } else {
                jtwain.setINT32(byArray, n, n3);
            }
        } else if (object instanceof String) {
            if (this.type == 7) {
                this.set32BitObjectAt(byArray, n, new Double((String)object));
            } else {
                this.set32BitObjectAt(byArray, n, new Integer((String)object));
            }
        } else {
            System.out.println(this.getClass().getName() + ".set32BitObjectAt:\n\tUnsupported type = " + this.type);
        }
    }

    protected Object getObjectAt(byte[] byArray, int n) {
        switch (this.type) {
            case 0: {
                return new Integer(byArray[n]);
            }
            case 1: {
                return new Integer(jtwain.getINT16(byArray, n));
            }
            case 2: {
                return new Integer(jtwain.getINT32(byArray, n));
            }
            case 3: {
                return new Integer(byArray[n] & 0xFF);
            }
            case 4: {
                return new Integer(jtwain.getINT16(byArray, n) & 0xFFFF);
            }
            case 5: {
                return new Long((long)jtwain.getINT32(byArray, n) & 0xFFFFFFFFL);
            }
            case 6: {
                return new Boolean(jtwain.getINT16(byArray, n) != 0);
            }
            case 7: {
                return new Double(jtwain.getFIX32(byArray, n));
            }
            case 8: {
                double d = jtwain.getFIX32(byArray, n);
                double d2 = jtwain.getFIX32(byArray, n + 4);
                double d3 = jtwain.getFIX32(byArray, n + 8) - d;
                double d4 = jtwain.getFIX32(byArray, n + 12) - d2;
                return new Rectangle2D.Double(d, d2, d3, d4);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                String string = "";
                for (int i = 0; byArray[n + i] != 0 && i < typeSizes[this.type]; ++i) {
                    string = string + (char)byArray[n + i];
                }
                return string;
            }
        }
        System.out.println(this.getClass().getName() + ".getObjectAt:\n\tUnsupported type = " + this.type);
        return null;
    }

    private void set16BitObjectAt(byte[] byArray, int n, Object object) {
        if (object instanceof Number) {
            int n2 = ((Number)object).intValue();
            jtwain.setINT16(byArray, n, n2);
        } else if (object instanceof Boolean) {
            int n3 = (Boolean)object != false ? 1 : 0;
            jtwain.setINT16(byArray, n, n3);
        } else {
            System.out.println("3\b" + this.getClass().getName() + ".set16BitObjectAt:\n\tUnsupported type = " + object.getClass().getName());
        }
    }

    protected void setObjectAt(byte[] byArray, int n, Object object) {
        switch (this.type) {
            case 1: 
            case 4: {
                this.set16BitObjectAt(byArray, n, object);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                this.set32BitObjectAt(byArray, n, object);
                break;
            }
            default: {
                System.out.println("3\b" + this.getClass().getName() + ".setObjectAt:\n\tUnsupported type = " + this.type);
            }
        }
    }

    public String toString() {
        String string = this.getClass().getName() + "\n";
        string = string + "cap          = 0x" + Integer.toHexString(this.cap) + "\n";
        string = string + "type         = 0x" + Integer.toHexString(this.type) + "\n";
        return string;
    }

    public static String toString(byte[] byArray) {
        int n;
        String string = "\n";
        for (n = 0; n < byArray.length; ++n) {
            string = string + " ";
            string = string + hexs[byArray[n] >> 4 & 0xF];
            string = string + hexs[byArray[n] & 0xF];
            if ((n + 1) % 8 != 0) continue;
            string = string + "\n";
        }
        if ((n + 1) % 8 != 0) {
            string = string + "\n";
        }
        return string;
    }
}

