/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import uk.co.mmscomputing.device.sane.SaneIOException;
import uk.co.mmscomputing.device.sane.option.DescriptorPanel;
import uk.co.mmscomputing.device.sane.option.FixedRange;

public class FixedRangePanel
extends DescriptorPanel {
    JSlider[] sliders = null;
    JTextField[] tfs = null;

    public FixedRangePanel(FixedRange fixedRange) {
        super(fixedRange);
        Dictionary dictionary = this.createSliderDictionary();
        int n = fixedRange.size >> 2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(n, 1));
        this.tfs = new JTextField[n];
        this.sliders = new JSlider[n];
        for (int i = 0; i < n; ++i) {
            jPanel.add(this.createRangePanel(i));
            this.sliders[i].setLabelTable(dictionary);
        }
        this.sliders[n - 1].setPaintLabels(true);
        this.addValuePanel(new JScrollPane(jPanel));
    }

    private Dictionary createSliderDictionary() {
        FixedRange fixedRange = (FixedRange)this.od;
        int n = (fixedRange.max - fixedRange.min) / 5;
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        int n2 = fixedRange.min;
        for (int i = 0; i <= 5; ++i) {
            ((Dictionary)hashtable).put(new Integer(n2), new JLabel(FixedRange.unfixstr(n2)));
            n2 += n;
        }
        return hashtable;
    }

    private JPanel createRangePanel(int n) {
        FixedRange fixedRange = (FixedRange)this.od;
        JSlider jSlider = new JSlider(0, fixedRange.min, fixedRange.max, fixedRange.min);
        jSlider.addChangeListener(this);
        this.checkCapabilities(jSlider);
        JTextField jTextField = new JTextField(10);
        jTextField.setHorizontalAlignment(4);
        jTextField.addActionListener(this);
        this.checkCapabilities(jTextField);
        jTextField.setText(fixedRange.getStringValue(n));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jSlider, "Center");
        jPanel.add((Component)jTextField, "East");
        jSlider.setValue(fixedRange.getWordValue(n));
        this.sliders[n] = jSlider;
        this.tfs[n] = jTextField;
        return jPanel;
    }

    void signalNewValue() {
        this.sliders[0].setValue(this.od.getWordValue(0));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        for (int i = 0; i < this.sliders.length; ++i) {
            if (this.sliders[i] != jSlider) continue;
            JTextField jTextField = this.tfs[i];
            FixedRange cfr_ignored_0 = (FixedRange)this.od;
            jTextField.setText(FixedRange.unfixstr(jSlider.getValue()));
            if (jSlider.getValueIsAdjusting()) continue;
            try {
                this.od.setWordValue(i, jSlider.getValue());
                jTextField.setText(this.od.getStringValue(i));
                continue;
            }
            catch (SaneIOException saneIOException) {
                saneIOException.printStackTrace();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextField jTextField = (JTextField)actionEvent.getSource();
        for (int i = 0; i < this.tfs.length; ++i) {
            if (this.tfs[i] != jTextField) continue;
            try {
                this.od.setStringValue(i, jTextField.getText());
                this.sliders[i].setValue(this.od.getWordValue(i));
                continue;
            }
            catch (SaneIOException saneIOException) {
                saneIOException.printStackTrace();
            }
        }
    }
}

