/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import uk.co.mmscomputing.device.sane.SaneConstants;
import uk.co.mmscomputing.device.sane.SaneDevice;
import uk.co.mmscomputing.device.sane.SaneIOException;
import uk.co.mmscomputing.device.sane.gui.SanePreviewImage;
import uk.co.mmscomputing.device.sane.jsane;
import uk.co.mmscomputing.device.sane.option.Descriptor;
import uk.co.mmscomputing.device.sane.option.FixedDesc;

public class SanePreviewPanel
extends JPanel
implements Runnable {
    private static String roititlestr = jsane.getResource("gui.SanePreviewPanel.roititlestr");
    SanePreviewImage image = null;
    JScrollPane scroll = null;
    JLabel posx = new JLabel("0");
    JLabel posy = new JLabel("0");
    JLabel tl_x = null;
    JLabel tl_y = null;
    JLabel br_x = null;
    JLabel br_y = null;
    JLabel lresolution = null;
    private HashMap options = null;
    private double resolution = 100.0;
    private Point off = new Point(0, 0);
    private Point newoff = new Point(0, 0);
    private SaneDevice scanner;

    public SanePreviewPanel(SaneDevice saneDevice, HashMap hashMap) {
        this.options = hashMap;
        this.scanner = saneDevice;
        this.setLayout(new BorderLayout());
        this.image = new SanePreviewImage(this);
        this.scroll = new JScrollPane(this.image);
        this.add((Component)this.scroll, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 3));
        this.posx.setBorder(new TitledBorder("mouse x [pixel]"));
        jPanel.add(this.posx);
        this.tl_x = this.createROILabel("tl-x");
        jPanel.add(this.tl_x);
        this.br_x = this.createROILabel("br-x");
        jPanel.add(this.br_x);
        this.posy.setBorder(new TitledBorder("mouse y [pixel]"));
        jPanel.add(this.posy);
        this.tl_y = this.createROILabel("tl-y");
        jPanel.add(this.tl_y);
        this.br_y = this.createROILabel("br-y");
        jPanel.add(this.br_y);
        this.lresolution = this.createROILabel("resolution");
        jPanel.add(this.lresolution);
        jPanel.add(new JLabel());
        jPanel.add(new JLabel());
        jPanel.setBorder(new TitledBorder(roititlestr));
        this.add((Component)jPanel, "South");
        this.setResolution();
    }

    public BufferedImage getImage() {
        return this.image.getImage();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image.setImage(bufferedImage);
    }

    public void run() {
        try {
            this.setResolution();
            BufferedImage bufferedImage = this.scanner.getImage(true);
            if (bufferedImage != null) {
                this.off.x = this.newoff.x;
                this.off.y = this.newoff.y;
                this.image.setImage(bufferedImage);
            }
        }
        catch (Throwable throwable) {
            System.gc();
            System.err.println(this.getClass().getName() + ".run\n\t" + throwable);
            throwable.printStackTrace();
            System.out.println("9\b" + this.getClass().getName() + ".run\n\t" + throwable);
        }
    }

    private JLabel createROILabel(String string) {
        JLabel jLabel;
        try {
            Descriptor descriptor = (Descriptor)this.options.get(string);
            jLabel = new JLabel(descriptor.getStringValue());
            TitledBorder titledBorder = new TitledBorder(string + " [" + SaneConstants.SANE_UNIT[descriptor.getUnit()] + "]");
            jLabel.setBorder(titledBorder);
        }
        catch (Exception exception) {
            jLabel = new JLabel(string);
            jLabel.setEnabled(false);
        }
        return jLabel;
    }

    public void revalidate() {
        if (this.options != null) {
            Object object;
            Descriptor descriptor;
            double d = 100.0;
            try {
                descriptor = (Descriptor)this.options.get("resolution");
                object = descriptor.getStringValue();
                this.lresolution.setText((String)object);
                d = Double.parseDouble((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                descriptor = (FixedDesc)this.options.get("tl-x");
                object = (FixedDesc)this.options.get("tl-y");
                FixedDesc fixedDesc = (FixedDesc)this.options.get("br-x");
                FixedDesc fixedDesc2 = (FixedDesc)this.options.get("br-y");
                this.tl_x.setText(((FixedDesc)descriptor).getStringValue(0));
                this.tl_y.setText(((FixedDesc)object).getStringValue(0));
                this.br_x.setText(fixedDesc.getStringValue(0));
                this.br_y.setText(fixedDesc2.getStringValue(0));
                this.newoff.x = ((FixedDesc)descriptor).getPixelValue(d);
                this.newoff.y = ((FixedDesc)object).getPixelValue(d);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.revalidate();
    }

    private void setResolution() {
        try {
            Descriptor descriptor = (Descriptor)this.options.get("resolution");
            double d = this.resolution;
            this.resolution = Double.parseDouble(descriptor.getStringValue());
            if (d != this.resolution) {
                this.lresolution.setText(descriptor.getStringValue());
                double d2 = this.resolution / d;
                this.newoff.x = (int)((double)this.newoff.x * d2);
                this.newoff.y = (int)((double)this.newoff.y * d2);
            }
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + ".setResolution:\n\t" + exception);
            exception.printStackTrace();
        }
    }

    void setXY(Point point) {
        this.posx.setText(Integer.toString(point.x));
        this.posy.setText(Integer.toString(point.y));
        this.scroll(point);
    }

    private double convert(String string, int n) {
        Descriptor descriptor = (Descriptor)this.options.get(string);
        return descriptor.convertPixelValue(this.resolution, n);
    }

    void setTopLeft(Point point) {
        try {
            this.tl_x.setText(Double.toString(this.convert("tl-x", this.off.x + point.x)));
            this.tl_y.setText(Double.toString(this.convert("tl-y", this.off.y + point.y)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setBottomRight(Point point) {
        try {
            this.br_x.setText(Double.toString(this.convert("br-x", this.off.x + point.x)));
            this.br_y.setText(Double.toString(this.convert("br-y", this.off.y + point.y)));
            this.scroll(point);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setROI(String string, int n) throws SaneIOException {
        Descriptor descriptor = (Descriptor)this.options.get(string);
        descriptor.setPixelValue(this.resolution, n);
    }

    void setROI(Rectangle rectangle) throws SaneIOException {
        this.newoff.x = this.off.x + rectangle.x;
        this.newoff.y = this.off.y + rectangle.y;
        this.setROI("tl-x", this.newoff.x);
        this.setROI("tl-y", this.newoff.y);
        this.setROI("br-x", this.newoff.x + rectangle.width);
        this.setROI("br-y", this.newoff.y + rectangle.height);
    }

    private void scroll(Point point) {
        JScrollBar jScrollBar;
        boolean bl;
        boolean bl2;
        JViewport jViewport = this.scroll.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        boolean bl3 = bl2 = point.x < rectangle.x + 10;
        if (bl2) {
            JScrollBar jScrollBar2 = this.scroll.getHorizontalScrollBar();
            jScrollBar2.setValue(jScrollBar2.getValue() - jScrollBar2.getUnitIncrement(10));
        }
        boolean bl4 = bl = point.y < rectangle.y + 10;
        if (bl) {
            jScrollBar = this.scroll.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getUnitIncrement(10));
        }
        boolean bl5 = bl2 = rectangle.x + rectangle.width - 10 < point.x;
        if (bl2) {
            jScrollBar = this.scroll.getHorizontalScrollBar();
            jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getUnitIncrement(10));
        }
        boolean bl6 = bl = rectangle.y + rectangle.height - 10 < point.y;
        if (bl) {
            jScrollBar = this.scroll.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getUnitIncrement(10));
        }
    }
}

