/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import uk.co.mmscomputing.device.sane.SaneConstants;
import uk.co.mmscomputing.device.sane.SaneDevice;
import uk.co.mmscomputing.device.sane.jsane;
import uk.co.mmscomputing.device.sane.option.DescriptorPanel;

public class SaneMaxDocsPanel
extends JPanel
implements SaneConstants,
DocumentListener {
    private static String adfcountdescstr = jsane.getResource("gui.SaneMaxDocsPanel.adfcountdescstr");
    protected SaneDevice scanner;
    protected JTextField tf;

    public SaneMaxDocsPanel(SaneDevice saneDevice) {
        this.scanner = saneDevice;
        this.setLayout(new BorderLayout());
        this.tf = new JTextField(10);
        this.tf.setHorizontalAlignment(4);
        this.tf.setText("" + saneDevice.getADFCount());
        Document document = this.tf.getDocument();
        document.addDocumentListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.tf, "Center");
        jPanel.setBorder(new TitledBorder(DescriptorPanel.valstr));
        this.add((Component)jPanel, "North");
        this.add((Component)this.newDescriptionPanel(adfcountdescstr), "Center");
    }

    private JComponent newDescriptionPanel(String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(DescriptorPanel.descstr));
        jPanel.add(jScrollPane);
        return jPanel;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.commit(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.commit(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.commit(documentEvent);
    }

    protected void commit(DocumentEvent documentEvent) {
        int n = -1;
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(document.getStartPosition().getOffset(), document.getEndPosition().getOffset()).trim();
            n = Integer.parseInt(string);
            if (n < 1) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception exception) {
            n = -1;
            try {
                document.remove(0, document.getLength());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (n > 1) {
            this.scanner.setADFMode(true);
        }
        this.scanner.setADFCount(n);
    }
}

