/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.sane;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.device.sane.OptionDescriptor;
import uk.co.mmscomputing.device.sane.Parameters;
import uk.co.mmscomputing.device.sane.SaneConstants;
import uk.co.mmscomputing.device.sane.SaneIOException;
import uk.co.mmscomputing.device.sane.SaneNoDocumentsException;
import uk.co.mmscomputing.device.sane.gui.SaneAcquirePanel;
import uk.co.mmscomputing.device.sane.jsane;
import uk.co.mmscomputing.device.sane.option.Descriptor;
import uk.co.mmscomputing.device.sane.option.FixedDesc;
import uk.co.mmscomputing.device.sane.option.IntDesc;
import uk.co.mmscomputing.device.sane.option.StringDesc;
import uk.co.mmscomputing.device.scanner.ScannerDevice;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.util.JarImageIcon;

public class SaneDevice
implements SaneConstants,
ScannerDevice {
    private static final int buffersize = 32768;
    private String name;
    private int saneHandle = 0;
    private boolean cancelled;
    private boolean userCancelled;
    private boolean adfmode;
    private int state;
    private int adfcount;
    private boolean showUI;
    private boolean showPB;
    private JProgressBar pbar;
    private Semaphore blocker;
    private static boolean isLitteEndian = true;

    SaneDevice(String string) {
        this.name = string;
        this.cancelled = false;
        this.userCancelled = false;
        this.adfmode = false;
        this.adfcount = -1;
        this.state = 5;
        this.showUI = true;
        this.showPB = true;
        this.pbar = null;
        this.blocker = new Semaphore(1, true);
    }

    public String getName() {
        return this.name;
    }

    public int getState() {
        return this.state;
    }

    void setState(int n) {
        this.state = n;
        jsane.signalStateChange(this);
    }

    synchronized boolean isState(int n) {
        return this.state == n;
    }

    public boolean isBusy() {
        return !this.isState(5);
    }

    public void checkBusy() throws SaneIOException {
        if (this.isBusy()) {
            throw new SaneIOException(this.getClass(), "checkBusy", "SaneDevice.ex.isbusy", this.name);
        }
    }

    public boolean getADFMode() {
        return this.adfmode;
    }

    public void setADFMode(boolean bl) {
        this.adfmode = bl;
    }

    public int getADFCount() {
        return this.adfcount;
    }

    public void setADFCount(int n) {
        this.adfcount = n;
    }

    public boolean isOpen() {
        return this.state == 1 || this.state == 2;
    }

    public void setShowUserInterface(boolean bl) {
        this.showUI = bl;
    }

    public void setShowProgressBar(boolean bl) {
        this.showPB = bl;
    }

    public void setProgressBar(JProgressBar jProgressBar) {
        this.pbar = jProgressBar;
    }

    private void setProgressBar(String string) {
        if (this.pbar != null) {
            this.pbar.setString(string);
        }
    }

    private void resetProgressBar(int n) {
        if (this.pbar != null) {
            this.pbar.setValue(0);
            this.pbar.setMaximum(n);
        }
    }

    private void setProgressBar(int n) {
        if (this.pbar != null) {
            this.pbar.setValue(n);
            if (n > 0xA00000) {
                this.pbar.setString("" + (n >>= 20) + " MB");
            } else if (n > 10240) {
                this.pbar.setString("" + (n >>= 10) + " kB");
            }
        }
    }

    public int getNumberOfOptions() throws SaneIOException {
        return jsane.getNumberOfOptions(this.saneHandle);
    }

    public OptionDescriptor getOptionDescriptor(int n) {
        return jsane.getOptionDescriptor(this.saneHandle, n);
    }

    public OptionDescriptor[] getOptionDescriptors() throws SaneIOException {
        OptionDescriptor[] optionDescriptorArray = new OptionDescriptor[this.getNumberOfOptions()];
        for (int i = 0; i < optionDescriptorArray.length; ++i) {
            try {
                optionDescriptorArray[i] = this.getOptionDescriptor(i);
                continue;
            }
            catch (Exception exception) {
                optionDescriptorArray[i] = null;
                continue;
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return optionDescriptorArray;
    }

    public void setOption(String string, String string2) throws ScannerIOException {
        int n = this.getNumberOfOptions();
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            Descriptor descriptor = (Descriptor)this.getOptionDescriptor(i);
            String string3 = descriptor.getName();
            if (!string.equals(string3)) continue;
            if (descriptor instanceof StringDesc) {
                stringArray = descriptor.setStringValue(string2);
                if (stringArray.equals(string2)) {
                    return;
                }
            } else if (descriptor instanceof FixedDesc) {
                double d = Double.parseDouble(string2);
                double d2 = Double.parseDouble(descriptor.setStringValue(0, string2));
                if (d2 == d) {
                    return;
                }
            } else if (descriptor instanceof IntDesc) {
                double d = Double.parseDouble(string2);
                double d3 = Double.parseDouble(descriptor.setStringValue(0, string2));
                if (d3 == d) {
                    return;
                }
            }
            stringArray = new String[]{string, string2};
            throw new SaneIOException(this.getClass(), "setOption", "SaneDevice.ex.couldnotsetoption", stringArray);
        }
        throw new ScannerIOException(this.getClass().getName() + ".setOption:\n\tCould not find option '" + string);
    }

    public void setOption(String string, double d) throws ScannerIOException {
        int n = this.getNumberOfOptions();
        for (int i = 0; i < n; ++i) {
            double d2;
            Descriptor descriptor = (Descriptor)this.getOptionDescriptor(i);
            String string2 = descriptor.getName();
            if (!string.equals(string2)) continue;
            if (descriptor instanceof FixedDesc ? (d2 = Double.parseDouble(descriptor.setStringValue(0, "" + d))) == d : descriptor instanceof IntDesc && (d2 = Double.parseDouble(descriptor.setStringValue(0, "" + (int)d))) == d) {
                return;
            }
            String[] stringArray = new String[]{string, "" + d};
            throw new SaneIOException(this.getClass(), "setOption", "SaneDevice.ex.couldnotsetoption", stringArray);
        }
        throw new SaneIOException(this.getClass(), "setOption", "SaneDevice.ex.couldnotfindoption", string);
    }

    public Descriptor getOption(String string) throws ScannerIOException {
        int n = this.getNumberOfOptions();
        for (int i = 0; i < n; ++i) {
            Descriptor descriptor = (Descriptor)this.getOptionDescriptor(i);
            String string2 = descriptor.getName();
            if (!string.equals(string2)) continue;
            return descriptor;
        }
        throw new SaneIOException(this.getClass(), "getOption", "SaneDevice.ex.couldnotfindoption", string);
    }

    public void setResolution(double d) throws ScannerIOException {
        this.setOption("resolution", d);
    }

    public void setRegionOfInterest(int n, int n2, int n3, int n4) throws ScannerIOException {
        Descriptor descriptor = this.getOption("tl-x");
        if (descriptor.getUnit() != 1) {
            int n5 = this.getOption("resolution").getWordValue(0);
            n = (int)descriptor.convertPixels2Units(n5, n);
            n2 = (int)descriptor.convertPixels2Units(n5, n);
            n3 = (int)descriptor.convertPixels2Units(n5, n3);
            n4 = (int)descriptor.convertPixels2Units(n5, n4);
        }
        this.setOption("tl-x", n);
        this.setOption("tl-y", n2);
        this.setOption("br-x", n + n3);
        this.setOption("br-y", n2 + n4);
    }

    public void setRegionOfInterest(double d, double d2, double d3, double d4) throws ScannerIOException {
        this.setOption("tl-x", d);
        this.setOption("tl-y", d2);
        this.setOption("br-x", d + d3);
        this.setOption("br-y", d2 + d4);
    }

    public void select(String string) throws ScannerIOException {
        this.select(string, true);
    }

    public void select(String string, boolean bl) throws ScannerIOException {
        if (this.state != 0) {
            throw new SaneIOException(this.getClass(), "select", "SaneDevice.ex.calledinwrongstate", "SANE_STATE_INITIALIZE");
        }
        String[] stringArray = jsane.getDevices(bl);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            string = stringArray[i];
            return;
        }
        throw new SaneIOException(this.getClass(), "select", "SaneDevice.ex.cannotfinddevice", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws SaneIOException {
        try {
            this.blocker.acquire();
            jsane.init();
            this.setState(0);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.blocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit() throws SaneIOException {
        try {
            this.blocker.acquire();
            jsane.exit();
            this.setState(5);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.blocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws SaneIOException {
        if (this.cancelled) {
            return;
        }
        try {
            this.blocker.acquire();
            if (this.cancelled) {
                return;
            }
            jsane.start(this.saneHandle);
            this.setState(2);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.blocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() throws SaneIOException {
        try {
            this.blocker.acquire();
            jsane.close(this.saneHandle);
            this.setState(4);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.blocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getParameters(Parameters parameters) throws SaneIOException {
        parameters.format = -1;
        parameters.lastFrame = 1;
        if (this.cancelled) {
            return;
        }
        try {
            this.blocker.acquire();
            if (this.cancelled) {
                return;
            }
            jsane.getParameters(this.saneHandle, parameters);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.blocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read(byte[] byArray, int n, int n2) throws SaneIOException {
        if (this.cancelled) {
            return -1;
        }
        try {
            this.blocker.acquire();
            if (this.cancelled) {
                int n3 = -1;
                return n3;
            }
            int n4 = jsane.read(this.saneHandle, byArray, n, n2);
            return n4;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.blocker.release();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        if (!this.isOpen() || this.cancelled) {
            return;
        }
        try {
            this.blocker.acquire();
            if (!this.isOpen() || this.cancelled) {
                return;
            }
            jsane.cancel(this.saneHandle);
            this.cancelled = true;
            this.setState(3);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.blocker.release();
        }
    }

    public void setCancel(boolean bl) {
        if (bl) {
            this.cancel();
        }
        this.userCancelled = bl;
    }

    public boolean getCancel() {
        return this.userCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createGrayImage(Parameters parameters, InputStream inputStream) throws IOException {
        try {
            inputStream = new BufferedInputStream(inputStream, 32768);
            if (parameters.depth == 1) {
                int n = parameters.bytesPerLine;
                int n2 = parameters.lines;
                this.resetProgressBar(n2);
                this.setProgressBar(0);
                BufferedImage bufferedImage = new BufferedImage(n << 3, n2, 12);
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                byte[] byArray = dataBufferByte.getData();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        byArray[n3++] = (byte)(~inputStream.read());
                    }
                    if (i % 100 != 0) continue;
                    this.setProgressBar(i);
                }
                this.setProgressBar(n2);
                BufferedImage bufferedImage2 = bufferedImage;
                return bufferedImage2;
            }
            if (parameters.depth == 8) {
                int n = parameters.bytesPerLine;
                int n4 = parameters.lines;
                this.resetProgressBar(n4);
                this.setProgressBar(0);
                BufferedImage bufferedImage = new BufferedImage(n, n4, 10);
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                byte[] byArray = dataBufferByte.getData();
                int n5 = 0;
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n; ++j) {
                        byArray[n5++] = (byte)inputStream.read();
                    }
                    if (i % 100 != 0) continue;
                    this.setProgressBar(i);
                }
                this.setProgressBar(n4);
                BufferedImage bufferedImage3 = bufferedImage;
                return bufferedImage3;
            }
            if (parameters.depth == 16) {
                int n;
                int n6 = parameters.bytesPerLine >> 1;
                int n7 = parameters.lines;
                this.resetProgressBar(n7);
                this.setProgressBar(0);
                BufferedImage bufferedImage = new BufferedImage(n6, n7, 11);
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
                short[] sArray = dataBufferUShort.getData();
                int n8 = 0;
                if (isLitteEndian) {
                    for (n = 0; n < n7; ++n) {
                        for (int i = 0; i < n6; ++i) {
                            sArray[n8++] = (short)(inputStream.read() & 0xFF | (inputStream.read() & 0xFF) << 8);
                        }
                        if (n % 100 != 0) continue;
                        this.setProgressBar(n);
                    }
                } else {
                    for (n = 0; n < n7; ++n) {
                        for (int i = 0; i < n6; ++i) {
                            sArray[n8++] = (short)((inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF);
                        }
                        if (n % 100 != 0) continue;
                        this.setProgressBar(n);
                    }
                }
                this.setProgressBar(n7);
                BufferedImage bufferedImage4 = bufferedImage;
                return bufferedImage4;
            }
            try {
                throw new SaneIOException(this.getClass(), "createGrayImage", "SaneDevice.ex.grayscaledepthnotsupported", "" + parameters.depth);
            }
            catch (Exception exception) {
                jsane.signalException(exception);
            }
        }
        finally {
            inputStream.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createRGBImage(Parameters parameters, InputStream inputStream) throws IOException {
        if (parameters.depth == 1) {
            throw new SaneIOException(this.getClass(), "createRGBImage", "SaneDevice.ex.rgbdepthnotsupported", "" + parameters.depth);
        }
        try {
            int n;
            int n2 = parameters.bytesPerLine / ((parameters.depth >> 3) * 3);
            int n3 = parameters.lines;
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            inputStream = new BufferedInputStream(inputStream, 32768);
            this.resetProgressBar(n3);
            this.setProgressBar(0);
            int n4 = 0;
            if (parameters.depth == 8) {
                for (n = 0; n < n3; ++n) {
                    for (int i = 0; i < n2; ++i) {
                        int n5 = inputStream.read() & 0xFF;
                        int n6 = inputStream.read() & 0xFF;
                        int n7 = inputStream.read() & 0xFF;
                        nArray[n4++] = 0xFF000000 | n5 << 16 | n6 << 8 | n7;
                    }
                    if (n % 100 != 0) continue;
                    this.setProgressBar(n);
                }
            } else if (parameters.depth == 16) {
                if (isLitteEndian) {
                    for (n = 0; n < n3; ++n) {
                        for (int i = 0; i < n2; ++i) {
                            inputStream.read();
                            int n8 = inputStream.read() & 0xFF;
                            inputStream.read();
                            int n9 = inputStream.read() & 0xFF;
                            inputStream.read();
                            int n10 = inputStream.read() & 0xFF;
                            nArray[n4++] = 0xFF000000 | n8 << 16 | n9 << 8 | n10;
                        }
                        if (n % 100 != 0) continue;
                        this.setProgressBar(n);
                    }
                } else {
                    for (n = 0; n < n3; ++n) {
                        for (int i = 0; i < n2; ++i) {
                            int n11 = inputStream.read() & 0xFF;
                            inputStream.read();
                            int n12 = inputStream.read() & 0xFF;
                            inputStream.read();
                            int n13 = inputStream.read() & 0xFF;
                            inputStream.read();
                            nArray[n4++] = 0xFF000000 | n11 << 16 | n12 << 8 | n13;
                        }
                        if (n % 100 != 0) continue;
                        this.setProgressBar(n);
                    }
                }
            } else {
                throw new SaneIOException(this.getClass(), "createRGBImage", "SaneDevice.ex.rgbdepthnotsupported", "" + parameters.depth);
            }
            this.setProgressBar(n3);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage create3FRGBImage(Parameters parameters, InputStream inputStream, InputStream inputStream2, InputStream inputStream3) throws IOException {
        try {
            int n;
            if (inputStream == null || inputStream2 == null || inputStream3 == null) {
                throw new SaneIOException(this.getClass(), "create3FRGBImage", "SaneDevice.ex.rgbframesmissing");
            }
            int n2 = parameters.bytesPerLine / (parameters.depth >> 3);
            int n3 = parameters.lines;
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            int n4 = 0;
            inputStream = new BufferedInputStream(inputStream, 32768);
            inputStream2 = new BufferedInputStream(inputStream2, 32768);
            inputStream3 = new BufferedInputStream(inputStream3, 32768);
            this.resetProgressBar(n3);
            this.setProgressBar(0);
            if (parameters.depth == 8) {
                for (n = 0; n < n3; ++n) {
                    for (int i = 0; i < n2; ++i) {
                        int n5 = inputStream.read();
                        int n6 = inputStream2.read();
                        int n7 = inputStream3.read();
                        nArray[n4++] = 0xFF000000 | n5 << 16 | n6 << 8 | n7;
                    }
                    if (n % 100 != 0) continue;
                    this.setProgressBar(n);
                }
            } else if (parameters.depth == 16) {
                if (isLitteEndian) {
                    for (n = 0; n < n3; ++n) {
                        for (int i = 0; i < n2; ++i) {
                            inputStream.read();
                            int n8 = inputStream.read();
                            inputStream2.read();
                            int n9 = inputStream2.read();
                            inputStream3.read();
                            int n10 = inputStream3.read();
                            nArray[n4++] = 0xFF000000 | n8 << 16 | n9 << 8 | n10;
                        }
                        if (n % 100 != 0) continue;
                        this.setProgressBar(n);
                    }
                } else {
                    for (n = 0; n < n3; ++n) {
                        for (int i = 0; i < n2; ++i) {
                            int n11 = inputStream.read();
                            inputStream.read();
                            int n12 = inputStream2.read();
                            inputStream2.read();
                            int n13 = inputStream3.read();
                            inputStream3.read();
                            nArray[n4++] = 0xFF000000 | n11 << 16 | n12 << 8 | n13;
                        }
                        if (n % 100 != 0) continue;
                        this.setProgressBar(n);
                    }
                }
            } else {
                throw new SaneIOException(this.getClass(), "create3FRGBImage", "SaneDevice.ex.rgbdepthnotsupported", "" + parameters.depth);
            }
            this.setProgressBar(n3);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            inputStream.close();
            inputStream2.close();
            inputStream3.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File readImageData(Parameters parameters) throws IOException {
        File file = File.createTempFile("mmsc_sane_", null);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 32768);
        byte[] byArray = new byte[32768];
        try {
            this.start();
            this.getParameters(parameters);
            this.resetProgressBar(parameters.bytesPerLine * parameters.lines);
            int n = 0;
            try {
                int n2;
                while ((n2 = this.read(byArray, 0, byArray.length)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                    this.setProgressBar(n += n2);
                }
            }
            catch (SaneIOException saneIOException) {
                jsane.signalException(saneIOException);
            }
            if (parameters.lines == -1) {
                parameters.lines = n / parameters.bytesPerLine;
            }
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
        return file;
    }

    public BufferedImage getImage(boolean bl) throws IOException {
        BufferedImage bufferedImage = this.getImage();
        this.cancel();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() throws IOException {
        File[] fileArray = new File[3];
        Parameters parameters = new Parameters();
        this.cancelled = false;
        try {
            Object object;
            int n;
            block12: for (n = 0; n < fileArray.length && parameters.lastFrame == 0; ++n) {
                object = this.readImageData(parameters);
                if (this.cancelled) break;
                switch (parameters.format) {
                    case 0: {
                        fileArray[0] = object;
                        continue block12;
                    }
                    case 1: {
                        fileArray[0] = object;
                        continue block12;
                    }
                    case 2: {
                        fileArray[0] = object;
                        continue block12;
                    }
                    case 3: {
                        fileArray[1] = object;
                        continue block12;
                    }
                    case 4: {
                        fileArray[2] = object;
                        continue block12;
                    }
                    default: {
                        parameters.lastFrame = 1;
                        n = -1;
                    }
                }
            }
            if (!this.cancelled) {
                if (n == 3) {
                    object = this.create3FRGBImage(parameters, new FileInputStream(fileArray[0]), new FileInputStream(fileArray[1]), new FileInputStream(fileArray[2]));
                    return object;
                }
                if (n == 1) {
                    if (parameters.format == 1) {
                        object = this.createRGBImage(parameters, new FileInputStream(fileArray[0]));
                        return object;
                    }
                    if (parameters.format == 0) {
                        object = this.createGrayImage(parameters, new FileInputStream(fileArray[0]));
                        return object;
                    }
                }
            }
        }
        finally {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i] == null) continue;
                fileArray[i].delete();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquire() {
        block20: {
            try {
                this.setProgressBar((JProgressBar)null);
                this.init();
                try {
                    Object object;
                    this.adfcount = -1;
                    this.userCancelled = false;
                    this.saneHandle = jsane.open(this.name);
                    this.setState(1);
                    jsane.negotiateOptions(this);
                    if (this.showUI) {
                        object = new Semaphore(0, true);
                        new SaneAcquirePanel(this, (Semaphore)object).display();
                        ((Semaphore)object).acquire();
                    }
                    object = this.showPB ? new ProgressMonitor(this.name) : null;
                    this.setProgressBar((JProgressBar)object);
                    this.setProgressBar("preparing " + this.name);
                    try {
                        if (this.userCancelled) break block20;
                        if (object != null) {
                            ((ProgressMonitor)object).open();
                        }
                        try {
                            do {
                                jsane.signalImage(this.getImage());
                                --this.adfcount;
                            } while (this.adfmode && this.adfcount != 0);
                        }
                        catch (SaneNoDocumentsException saneNoDocumentsException) {
                            if (!this.adfmode) {
                                throw saneNoDocumentsException;
                            }
                        }
                        finally {
                            this.cancel();
                        }
                    }
                    finally {
                        this.close();
                        if (object != null) {
                            ((ProgressMonitor)object).close();
                        }
                    }
                }
                catch (Exception exception) {
                    jsane.signalException(exception);
                }
                finally {
                    this.exit();
                }
            }
            catch (Exception exception) {
                jsane.signalException(exception);
            }
        }
    }

    static {
        String string = System.getProperty("sun.cpu.endian");
        if (string != null) {
            isLitteEndian = string.equals("little");
        }
    }

    private class ProgressMonitor
    extends JProgressBar {
        JFrame dialog;

        ProgressMonitor(String string) {
            super(0, 100);
            this.setStringPainted(true);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            Border border = jPanel2.getBorder();
            EmptyBorder emptyBorder = new EmptyBorder(10, 10, 5, 10);
            jPanel2.setBorder(new CompoundBorder(border, emptyBorder));
            jPanel2.add((Component)new JLabel("Scanner:"), "North");
            JLabel jLabel = new JLabel(new JarImageIcon(this.getClass(), "32x32/scanner.png"));
            jLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
            jPanel2.add((Component)jLabel, "West");
            JLabel jLabel2 = new JLabel("<html>" + string + "</html>");
            jLabel2.setBorder(new EmptyBorder(10, 10, 10, 10));
            jPanel2.add((Component)jLabel2, "Center");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(5, 0, 5, 0));
            jPanel3.add((Component)this, "North");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(0, 3));
            jPanel4.add(new JPanel());
            JButton jButton = new JButton(new AbstractAction("cancel"){

                public void actionPerformed(ActionEvent actionEvent) {
                    SaneDevice.this.setCancel(true);
                }
            });
            jPanel4.add(jButton);
            jPanel4.add(new JPanel());
            jPanel3.add((Component)jPanel4, "Center");
            jPanel2.add((Component)jPanel3, "South");
            jPanel.setLayout(new BorderLayout());
            jPanel.setOpaque(true);
            jPanel.add((Component)jPanel2, "North");
            this.dialog = new JFrame(jsane.getResource("SaneDevice.ProgressMonitor.title"));
            this.dialog.setContentPane(jPanel);
            this.dialog.pack();
        }

        void open() {
            this.dialog.setLocationRelativeTo(null);
            this.dialog.toFront();
            this.dialog.setVisible(true);
        }

        void close() {
            this.dialog.setVisible(false);
        }
    }
}

