/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.printmonitor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import uk.co.mmscomputing.device.printmonitor.PMOutputStreamFactory;

public class Port {
    private static final int PS_STARTDOC = 1;
    private static final int PS_OPENED = 2;
    private String name;
    private String monitor;
    private String description;
    private String documentspath;
    private String document;
    private String printer;
    private int status;
    private int job;
    private OutputStream out = null;
    private int outputmode = 3;

    Port(String string, String string2, String string3) {
        this.monitor = string2;
        this.name = string;
        this.description = string3;
        this.documentspath = "";
        this.outputmode = 3;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getJob() {
        return this.job;
    }

    public String getPrinter() {
        return this.printer;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int getOutputMode() {
        return this.outputmode;
    }

    public void setOutputMode(int n) {
        this.outputmode = n;
    }

    public String getDocumentsPath() {
        return this.documentspath;
    }

    public void setDocumentsPath(String string) {
        this.documentspath = string;
    }

    private int getSize(String string) {
        return (string.length() + 1) * 2;
    }

    int getPortInfoSize(int n) {
        switch (n) {
            case 1: {
                return 4 + this.getSize(this.name);
            }
            case 2: {
                return 20 + this.getSize(this.name) + this.getSize(this.monitor) + this.getSize(this.description);
            }
        }
        return 0;
    }

    private int writeInt(byte[] byArray, int n, int n2) throws IOException {
        byArray[n++] = (byte)(n2 & 0xFF);
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >> 24 & 0xFF);
        return n;
    }

    private int writeChar(byte[] byArray, int n, char c) throws IOException {
        byArray[--n] = (byte)(c >> 8 & 0xFF);
        byArray[--n] = (byte)(c & 0xFF);
        return n;
    }

    private int writeString(byte[] byArray, int n, String string) throws IOException {
        n = this.writeChar(byArray, n, '\u0000');
        for (int i = string.length() - 1; i >= 0; --i) {
            n = this.writeChar(byArray, n, string.charAt(i));
        }
        return n;
    }

    int writePortInfo(int n, int n2, byte[] byArray, int n3, int n4) throws IOException {
        switch (n) {
            case 1: {
                n4 = this.writeString(byArray, n4, this.name);
                this.writeInt(byArray, n3, n2 + n4);
                break;
            }
            case 2: {
                n4 = this.writeString(byArray, n4, this.monitor);
                this.writeInt(byArray, n3 + 4, n2 + n4);
                n4 = this.writeString(byArray, n4, this.description);
                this.writeInt(byArray, n3 + 8, n2 + n4);
                n4 = this.writeString(byArray, n4, this.name);
                this.writeInt(byArray, n3, n2 + n4);
            }
        }
        return n4;
    }

    synchronized boolean open() {
        try {
            System.out.println("Open port " + this.name);
            this.status |= 2;
            return true;
        }
        catch (Throwable throwable) {
            System.err.println(this.getClass().getName() + ".open:\n\t" + throwable);
            this.status &= 0xFFFFFFFD;
            return false;
        }
    }

    synchronized boolean start(String string, int n, String string2) {
        if ((this.status & 1) != 0) {
            return false;
        }
        try {
            this.printer = string;
            this.document = string2;
            this.job = n;
            System.out.println("Start printing \"" + string2 + "\" on printer " + string + " to file " + this.documentspath + " output mode = " + this.outputmode);
            this.out = PMOutputStreamFactory.getOutputStream(this.outputmode, this.documentspath, string2);
            if (this.out != null) {
                this.status |= 1;
                return true;
            }
            this.status &= 0xFFFFFFFE;
            return false;
        }
        catch (Throwable throwable) {
            System.err.println(this.getClass().getName() + ".start:\n\t" + throwable);
            this.status &= 0xFFFFFFFE;
            return false;
        }
    }

    int write(byte[] byArray) {
        try {
            this.out.write(byArray);
            return byArray.length;
        }
        catch (Throwable throwable) {
            System.err.println(this.getClass().getName() + ".write:\n\t" + throwable);
            return -1;
        }
    }

    boolean end() {
        try {
            System.out.println("Stop printing \"" + this.document + "\" on printer " + this.printer);
            this.out.close();
            this.out = null;
        }
        catch (Throwable throwable) {
            System.err.println(this.getClass().getName() + ".end:\n\t" + throwable);
        }
        this.status &= 0xFFFFFFFE;
        this.printer = "";
        this.document = "";
        this.job = -1;
        return true;
    }

    boolean close() {
        try {
            System.out.println("Closed port " + this.name);
        }
        catch (Throwable throwable) {
            System.err.println(this.getClass().getName() + ".close:\n\t" + throwable);
        }
        this.status &= 0xFFFFFFFD;
        return true;
    }

    void save(Properties properties, int n) {
        try {
            String string = "port." + n;
            properties.setProperty(string + ".name", this.name);
            properties.setProperty(string + ".path", this.documentspath);
            properties.setProperty(string + ".desc", this.description);
            properties.setProperty(string + ".mode", Integer.toString(this.outputmode));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void load(Properties properties, int n) {
        try {
            String string = "port." + n;
            this.name = properties.getProperty(string + ".name");
            this.documentspath = properties.getProperty(string + ".path");
            this.description = properties.getProperty(string + ".desc");
            this.outputmode = Integer.parseInt(properties.getProperty(string + ".mode"));
        }
        catch (Exception exception) {
            this.outputmode = 3;
        }
    }
}

