/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.printmonitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import uk.co.mmscomputing.device.printmonitor.Port;

public class PMConfigurationPanel
extends JPanel
implements ActionListener {
    private static String[][] filters = new String[][]{{"SFF", "Structured Fax File CAPI"}, {"MH", "Fax T.4 Modified Huffman"}, {"MR", "Fax T.4 Modified READ"}, {"MMR", "Fax T.6 Modified Modified READ"}, {"NONE", "None"}};
    private static int[] modes = new int[]{0, 1, 2, 3, 4};
    private JFrame dialog;
    private ButtonGroup filterbuttons = new ButtonGroup();
    private JTextField doctf = new JTextField(32);
    private JTextField nametf = new JTextField(32);
    private JTextField desctf = new JTextField(32);
    private int outputmode = 3;
    private int outputmodenew = 3;
    private Port port;
    private boolean wantToAdd;

    PMConfigurationPanel(Port port, boolean bl) {
        super(new BorderLayout());
        this.wantToAdd = bl;
        this.port = port;
        this.outputmodenew = this.outputmode = port.getOutputMode();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Description", this.getTextFieldsPanel(port));
        jTabbedPane.addTab("Compression", this.getFilterPanel(port));
        this.add((Component)jTabbedPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton("ok");
        jButton.setActionCommand("ok");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        jButton = new JButton("cancel");
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
    }

    private JPanel getFilterPanel(Port port) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        ButtonGroup buttonGroup = this.filterbuttons;
        for (int i = 0; i < modes.length; ++i) {
            JRadioButton jRadioButton = new JRadioButton(filters[i][1]);
            jRadioButton.setActionCommand(filters[i][0]);
            jRadioButton.addActionListener(this);
            if (this.outputmode == modes[i]) {
                jRadioButton.setSelected(true);
            }
            buttonGroup.add(jRadioButton);
            jPanel.add(jRadioButton);
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        return jPanel2;
    }

    private JPanel getTextFieldsPanel(Port port) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(this.getNamePanel(port));
        jPanel.add(this.getDescriptionPanel(port));
        jPanel.add(this.getDocumentPathPanel(port));
        return jPanel;
    }

    private JPanel getNamePanel(Port port) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        Border border = BorderFactory.createLineBorder(Color.black);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Port Name");
        titledBorder.setTitleJustification(2);
        jPanel.setBorder(titledBorder);
        this.nametf.setText(port.getName());
        this.nametf.setEditable(this.wantToAdd);
        jPanel.add(this.nametf);
        return jPanel;
    }

    private JPanel getDescriptionPanel(Port port) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        Border border = BorderFactory.createLineBorder(Color.black);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Description");
        titledBorder.setTitleJustification(2);
        jPanel.setBorder(titledBorder);
        this.desctf.setText(port.getDescription());
        this.desctf.setEditable(this.wantToAdd);
        jPanel.add(this.desctf);
        return jPanel;
    }

    private JPanel getDocumentPathPanel(Port port) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        Border border = BorderFactory.createLineBorder(Color.black);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Documents Path");
        titledBorder.setTitleJustification(2);
        jPanel.setBorder(titledBorder);
        this.doctf.setText(port.getDocumentsPath());
        jPanel.add(this.doctf);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block2: {
            String string;
            block3: {
                block1: {
                    string = actionEvent.getActionCommand();
                    if (!string.equals("ok")) break block1;
                    this.outputmode = this.outputmodenew;
                    this.port.setName(this.nametf.getText());
                    this.port.setDescription(this.desctf.getText());
                    this.port.setOutputMode(this.outputmode);
                    this.port.setDocumentsPath(this.doctf.getText());
                    if (this.dialog == null) break block2;
                    this.dialog.dispose();
                    break block2;
                }
                if (!string.equals("cancel")) break block3;
                if (this.dialog == null) break block2;
                this.dialog.dispose();
                break block2;
            }
            for (int i = 0; i < modes.length; ++i) {
                if (!string.equals(filters[i][0])) continue;
                this.outputmodenew = modes[i];
                break;
            }
        }
    }

    public void display() {
        try {
            this.dialog = new JFrame("Java Print Monitor Configuration Panel");
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(null);
            this.dialog.setVisible(true);
            this.dialog.toFront();
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ".display:\n\t" + exception);
            exception.printStackTrace();
        }
    }
}

