/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.phone;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import uk.co.mmscomputing.device.capi.CapiPhoneCaller;
import uk.co.mmscomputing.device.phone.PhoneCallerGUI;
import uk.co.mmscomputing.device.phone.PhoneCallerListener;
import uk.co.mmscomputing.device.phone.PhoneCallerMetadata;
import uk.co.mmscomputing.device.phone.PhoneCallerPanel;
import uk.co.mmscomputing.device.phone.PhoneConstants;

public abstract class PhoneCaller
implements PhoneConstants {
    protected static boolean installed = false;
    protected Vector listeners = new Vector();
    protected PhoneCallerMetadata md = new PhoneCallerMetadata();

    public abstract boolean isAPIInstalled();

    public abstract void call() throws IOException;

    public void setMetadata(Properties properties) {
        new PhoneCallerPanel(this, this.md, properties).display();
    }

    public void addListener(PhoneCallerListener phoneCallerListener) {
        this.listeners.add(phoneCallerListener);
    }

    public void fireListenerUpdate(PhoneCallerMetadata.Type type) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            PhoneCallerListener phoneCallerListener = (PhoneCallerListener)enumeration.nextElement();
            phoneCallerListener.update(type, this.md);
        }
    }

    public JComponent getGUI(Properties properties) {
        return new PhoneCallerGUI(properties, this);
    }

    public static PhoneCaller getDevice() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Linux")) {
            PhoneCaller phoneCaller = CapiPhoneCaller.getDevice();
            if (phoneCaller.isAPIInstalled()) {
                return phoneCaller;
            }
        } else if (string.startsWith("Windows")) {
            PhoneCaller phoneCaller = CapiPhoneCaller.getDevice();
            if (phoneCaller.isAPIInstalled()) {
                return phoneCaller;
            }
        } else if (string.startsWith("Mac")) {
            // empty if block
        }
        return null;
    }
}

