/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.phone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.device.phone.PhoneCallSaver;
import uk.co.mmscomputing.sound.SoundMixer;
import uk.co.mmscomputing.sound.SoundMixerEnumerator;

public class PhoneCallMonitor
extends PhoneCallSaver
implements WindowListener {
    private Semaphore blocker;
    private Semaphore pickup = new Semaphore(0, true);
    private boolean active = false;
    private JFrame gui = null;
    private Recorder recorder;
    private SourceDataLine speaker = null;
    private TargetDataLine microphone = null;

    public PhoneCallMonitor() {
        this.blocker = new Semaphore(0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String string, String string2, InputStream inputStream, OutputStream outputStream) {
        try {
            this.microphone = SoundMixerEnumerator.getInputLine(pcmformat, 512);
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.out.println("\u0003b" + this.getClass().getName() + ".<init>:\n\tCould not create microphone input stream.\n\t" + lineUnavailableException);
        }
        try {
            this.speaker = SoundMixerEnumerator.getOutputLine(pcmformat, 512);
        }
        catch (LineUnavailableException lineUnavailableException) {
            this.microphone.close();
            System.out.println("\u0003b" + this.getClass().getName() + ".<init>:\n\tCould not create speaker output stream.\n\t" + lineUnavailableException);
        }
        if (this.speaker == null || this.microphone == null) {
            super.run(string, string2, inputStream, outputStream);
            return;
        }
        try {
            this.recorder = new Recorder(outputStream);
            this.recorder.start();
            this.gui = this.openMonitorGUI("Remote " + string2 + " Local " + string);
            inputStream.skip(inputStream.available());
            super.run(string, string2, new PhoneCallMonitorInputStream(inputStream), outputStream);
            this.recorder.interrupt();
            this.gui.dispose();
        }
        catch (Exception exception) {
            System.out.println("3\b" + this.getClass().getName() + ".run:\n\t" + exception);
            exception.printStackTrace();
        }
        finally {
            this.deactivate();
            this.microphone.close();
            this.speaker.close();
            if (this.gui != null) {
                this.gui.dispose();
            }
        }
    }

    public void pickup() {
        this.pickup.release();
    }

    public void activate() {
        this.active = true;
        this.microphone.flush();
        this.speaker.flush();
        this.speaker.start();
        this.blocker.release();
        this.microphone.start();
        this.microphone.flush();
    }

    public void deactivate() {
        this.active = false;
        this.microphone.stop();
        this.microphone.flush();
        this.speaker.stop();
        this.speaker.flush();
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.activate();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.stopRunning();
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.stopRunning();
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.deactivate();
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.activate();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.deactivate();
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.activate();
    }

    JFrame openMonitorGUI(String string) {
        try {
            MonitorGUI monitorGUI = new MonitorGUI(this, string);
            JFrame jFrame = new JFrame(string);
            jFrame.setDefaultCloseOperation(2);
            jFrame.addWindowListener(this);
            jFrame.getContentPane().add(monitorGUI);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
            jFrame.setSize(400, 200);
            jFrame.setLocationRelativeTo(null);
            jFrame.pack();
            jFrame.setVisible(true);
            return jFrame;
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + "\n\t" + exception);
            return null;
        }
    }

    static {
        try {
            SoundMixer soundMixer = SoundMixerEnumerator.getMixerByVendor("mm's computing");
            System.out.println("Mixer " + soundMixer.getMixerInfo() + " is available");
        }
        catch (Exception exception) {
            System.out.println("9\b" + exception.getMessage());
        }
    }

    private class MonitorGUI
    extends JComponent {
        private PhoneCallMonitor pcm;
        private JTextPane text = new JTextPane();
        private JButton button;

        public MonitorGUI(final PhoneCallMonitor phoneCallMonitor2, String string) {
            this.pcm = phoneCallMonitor2;
            this.text.setFont(new Font("Courier", 0, 12));
            this.text.setText(string);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 0));
            this.button = new JButton(new AbstractAction("Pick Up"){

                public void actionPerformed(ActionEvent actionEvent) {
                    MonitorGUI.this.button.setEnabled(false);
                    phoneCallMonitor2.pickup();
                }
            });
            jPanel.add(this.button);
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(this.text), "Center");
            this.add((Component)jPanel, "South");
        }
    }

    class PhoneCallMonitorInputStream
    extends FilterInputStream {
        public PhoneCallMonitorInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read() throws IOException {
            IOException iOException = new IOException(this.getClass().getName() + ".read:\n\tInternal Error.");
            iOException.printStackTrace();
            throw iOException;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            while (this.in.available() > n2) {
                this.in.read(byArray, n, n2);
            }
            if ((n2 = this.in.read(byArray, n, n2)) == -1) {
                return -1;
            }
            if (PhoneCallMonitor.this.isrunning && PhoneCallMonitor.this.active) {
                PhoneCallMonitor.this.speaker.write(byArray, n, n2);
            }
            return n2;
        }
    }

    private class Recorder
    extends Thread {
        private OutputStream pout;

        public Recorder(OutputStream outputStream) {
            this.pout = outputStream;
        }

        public void run() {
            block7: {
                int n = -1;
                byte[] byArray = new byte[512];
                try {
                    PhoneCallMonitor.this.pickup.acquire();
                    if (!PhoneCallMonitor.this.isrunning) break block7;
                    PhoneCallMonitor.this.stopPlaying();
                    PhoneCallMonitor.this.activate();
                    do {
                        PhoneCallMonitor.this.blocker.acquire();
                        if (!PhoneCallMonitor.this.isrunning) continue;
                        try {
                            new Semaphore(0, true).tryAcquire(500L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        PhoneCallMonitor.this.microphone.flush();
                        while (PhoneCallMonitor.this.isrunning && PhoneCallMonitor.this.active && (n = PhoneCallMonitor.this.microphone.read(byArray, 0, 512)) != -1) {
                            this.pout.write(byArray, 0, n);
                        }
                    } while (PhoneCallMonitor.this.isrunning && n >= 0);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    System.out.println("9\b" + this.getClass().getName() + ".run\n\tCould not create answer thread." + exception);
                }
            }
        }
    }
}

