/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.phone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import uk.co.mmscomputing.device.phone.IndicationProgressMonitor;
import uk.co.mmscomputing.device.phone.PhoneAnswererListener;
import uk.co.mmscomputing.device.phone.PhoneAnswererMetadata;
import uk.co.mmscomputing.device.phone.PhoneBook;
import uk.co.mmscomputing.device.phone.PhoneCallHandler;
import uk.co.mmscomputing.device.phone.PhoneCallHandlerFactory;
import uk.co.mmscomputing.device.phone.PhoneCallSaver;
import uk.co.mmscomputing.device.phone.PhoneColumnModel;
import uk.co.mmscomputing.device.phone.PhoneConstants;
import uk.co.mmscomputing.device.phone.PhoneEntry;
import uk.co.mmscomputing.device.phone.PhoneModel;

public class PhoneAnswererPanel
extends JPanel
implements PhoneConstants,
PhoneAnswererListener {
    protected Properties properties;
    protected PhoneCallHandlerFactory handlerfactory;
    protected PhoneBook phonebook;
    private JTable table;
    private PhoneModel model = new PhoneModel();
    private PhoneColumnModel columnmodel = new PhoneColumnModel();
    private static boolean addedPhoneBookListener = false;

    public PhoneAnswererPanel(Properties properties, PhoneCallHandlerFactory phoneCallHandlerFactory, PhoneBook phoneBook) {
        this.properties = properties;
        this.handlerfactory = phoneCallHandlerFactory;
        this.phonebook = phoneBook;
        this.setLayout(new BorderLayout());
        this.table = new JTable(this.model, this.columnmodel);
        this.table.createDefaultColumnsFromModel();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.buildCallList();
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isMetaDown()) {
                    int n = PhoneAnswererPanel.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    PhoneAnswererPanel.this.table.setRowSelectionInterval(n, n);
                    if (mouseEvent.getClickCount() == 2) {
                        PhoneAnswererPanel.this.deletePhoneCalls();
                    }
                } else if (mouseEvent.isShiftDown()) {
                    int n = PhoneAnswererPanel.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    PhoneAnswererPanel.this.table.setRowSelectionInterval(n, n);
                    if (mouseEvent.getClickCount() == 2) {
                        PhoneAnswererPanel.this.updatePhoneBook(PhoneAnswererPanel.this.model.getRemote(n));
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    int n = PhoneAnswererPanel.this.table.getSelectedRow();
                    if (n == -1) {
                        return;
                    }
                    PhoneAnswererPanel.this.table.setRowSelectionInterval(n, n);
                    PhoneAnswererPanel.this.playPhoneCall(PhoneAnswererPanel.this.model.getTime(n), PhoneAnswererPanel.this.model.getLocal(n), PhoneAnswererPanel.this.model.getRemote(n), PhoneAnswererPanel.this.model.getFile(n));
                }
            }
        });
    }

    private void addPropertyChangeListener(String string) {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            Component component;
            JTabbedPane jTabbedPane;
            int n;
            if (!(container instanceof JTabbedPane) || (n = (jTabbedPane = (JTabbedPane)container).indexOfTab(string)) == -1 || !((component = jTabbedPane.getComponentAt(n)) instanceof PropertyChangeListener)) continue;
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)((Object)component);
            this.addPropertyChangeListener(propertyChangeListener);
            return;
        }
    }

    protected void playPhoneCall(String string, String string2, String string3, String string4) {
        System.out.println("5\bPlay Sound File: " + string4);
    }

    protected void updatePhoneBook(String string) {
        if (!addedPhoneBookListener) {
            addedPhoneBookListener = true;
            this.addPropertyChangeListener("Phone Book");
        }
        this.firePropertyChange("update", null, string);
    }

    protected void deletePhoneCalls() {
        int[] nArray = this.table.getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            ((PhoneModel)this.table.getModel()).delEntry(nArray[i]);
        }
        this.table.revalidate();
    }

    private int getPickUpTime(String string) {
        try {
            String[] stringArray = this.properties.getProperty("uk.co.mmscomputing.device.phone.localnos", "").split(",");
            if (stringArray.length == 1 && stringArray[0].equals("")) {
                try {
                    return Integer.parseInt(this.properties.getProperty("uk.co.mmscomputing.device.phone.timetowait"));
                }
                catch (Exception exception) {
                    System.out.println("3\b" + this.getClass().getName() + ".update:\n\tCould not set pick up time.\n\t" + exception);
                    return 20;
                }
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.trim().equals(stringArray[i])) continue;
                try {
                    return Integer.parseInt(this.properties.getProperty("uk.co.mmscomputing.device.phone.timetowait"));
                }
                catch (Exception exception) {
                    System.out.println("3\b" + this.getClass().getName() + ".update:\n\tCould not set pick up time.\n\t" + exception);
                    return 20;
                }
            }
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + ".getPickUpTime:\n\t" + exception);
            exception.printStackTrace();
        }
        return -1;
    }

    public void update(PhoneAnswererMetadata.Type type, PhoneAnswererMetadata phoneAnswererMetadata) {
        try {
            if (type.equals(PhoneAnswererMetadata.STATE)) {
                PhoneCallHandler phoneCallHandler;
                if (phoneAnswererMetadata.isState(1)) {
                    int n = this.getPickUpTime(phoneAnswererMetadata.getLocalNo());
                    if (n != -1) {
                        String string = phoneAnswererMetadata.getRemoteNo();
                        IndicationProgressMonitor indicationProgressMonitor = new IndicationProgressMonitor(phoneAnswererMetadata.getController(), string, this.phonebook.getName(string), n * 1000);
                        phoneAnswererMetadata.setPickUpTime(n, indicationProgressMonitor);
                        try {
                            phoneAnswererMetadata.setALaw(this.properties.getProperty("uk.co.mmscomputing.device.phone.isalaw").equals("true"));
                        }
                        catch (Exception exception) {
                            System.out.println("3\b" + this.getClass().getName() + ".update:\n\tCould not speech coding constant.\n\t" + exception);
                            phoneAnswererMetadata.setALaw(true);
                        }
                    }
                } else if (phoneAnswererMetadata.isState(2)) {
                    PhoneCallHandler phoneCallHandler2 = this.handlerfactory.getHandler(this.properties);
                    phoneAnswererMetadata.setHandler(phoneCallHandler2);
                } else if (phoneAnswererMetadata.isState(0) && (phoneCallHandler = phoneAnswererMetadata.getHandler()) instanceof PhoneCallSaver) {
                    String string = ((PhoneCallSaver)phoneCallHandler).getFile();
                    if (phoneAnswererMetadata.getChangedProtocol()) {
                        if (string != null) {
                            new File(string).delete();
                        }
                    } else if (string != null) {
                        this.model.addEntry(this.parseFileName(new File(string)));
                        this.table.revalidate();
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".update:\n\t" + exception);
            exception.printStackTrace();
        }
    }

    private PhoneEntry parseFileName(File file) {
        String string = file.getName();
        String[] stringArray = (string = string.substring(0, string.indexOf(46))).split("_");
        String string2 = stringArray.length >= 1 ? stringArray[0] : "unknown";
        String string3 = stringArray.length >= 2 ? stringArray[1].replace('-', ':') : "unknown";
        String string4 = stringArray.length >= 3 ? stringArray[2] : "unknown";
        String string5 = stringArray.length >= 4 ? stringArray[3] : "withhold";
        String string6 = this.phonebook.getName(string5);
        return new PhoneEntry(string2 + " " + string3, string4, string5, string6, file.getAbsolutePath());
    }

    protected void buildCallList() {
        this.properties.setProperty("uk.co.mmscomputing.device.phone.dir", this.properties.getProperty("uk.co.mmscomputing.device.phone.dir", phoneDefaultPath));
        String string = this.properties.getProperty("uk.co.mmscomputing.device.phone.dir");
        String[] stringArray = this.list(string, new fnf());
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(string, stringArray[i]);
            try {
                this.model.addEntry(this.parseFileName(file));
                continue;
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ".parseFileName:\n\t" + exception);
                exception.printStackTrace();
            }
        }
    }

    private String[] list(String string, FilenameFilter filenameFilter) {
        Object[] objectArray = new File(string).list(filenameFilter);
        if (objectArray == null) {
            return new String[0];
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    class fnf
    implements FilenameFilter {
        fnf() {
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            return file2.isFile() && string.endsWith(".wav");
        }
    }
}

