/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.fax;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import uk.co.mmscomputing.device.fax.FaxConstants;
import uk.co.mmscomputing.device.fax.FaxPropertiesPanel;
import uk.co.mmscomputing.device.fax.FaxSender;
import uk.co.mmscomputing.device.fax.FaxSenderMetadata;
import uk.co.mmscomputing.util.JarImageIcon;

public class FaxSenderPanel
extends JPanel
implements FaxConstants {
    private FaxSenderMetadata md;
    private FaxSender sender = null;
    private JDialog dialog = null;
    private JTabbedPane tp = null;

    public FaxSenderPanel(FaxSender faxSender, FaxSenderMetadata faxSenderMetadata, Properties properties) {
        this.sender = faxSender;
        this.md = faxSenderMetadata;
        this.setLayout(new BorderLayout());
        this.tp = new JTabbedPane();
        this.tp.addTab("Properties", new FaxPropertiesPanel(false, true, properties));
        this.add((Component)this.tp, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton("send", new JarImageIcon(this.getClass(), "32x32/fax.png"));
        jButton.addActionListener(EventHandler.create(ActionListener.class, this, "send"));
        jPanel.add(jButton);
        jButton = new JButton("cancel");
        jButton.addActionListener(EventHandler.create(ActionListener.class, this, "cancel"));
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
    }

    public synchronized void send() {
        String string;
        this.sender.fireListenerUpdate(FaxSenderMetadata.GETFILE);
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
        if ((string = this.md.getFile()) != null) {
            new Thread(){

                public void run() {
                    try {
                        FaxSenderPanel.this.sender.send();
                    }
                    catch (Exception exception) {
                        System.out.println("9\b" + this.getClass().getName() + "\n\tCould not send fax file.\n\t" + exception.getMessage());
                    }
                }
            }.start();
        }
    }

    public void cancel() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public void display() {
        try {
            this.dialog = new JDialog((Frame)null, "Fax Sender Panel", true);
            this.dialog.setContentPane(this);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.dialog.setLocationRelativeTo(null);
            this.dialog.pack();
            this.dialog.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + "display:\n\t" + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

