/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.fax;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import uk.co.mmscomputing.device.capi.CapiFaxSender;
import uk.co.mmscomputing.device.fax.FaxConstants;
import uk.co.mmscomputing.device.fax.FaxPanel;
import uk.co.mmscomputing.device.fax.FaxSenderListener;
import uk.co.mmscomputing.device.fax.FaxSenderMetadata;
import uk.co.mmscomputing.device.fax.FaxSenderPanel;

public abstract class FaxSender
implements FaxConstants {
    protected static boolean installed = false;
    protected Vector listeners = new Vector();
    protected FaxSenderMetadata md = new FaxSenderMetadata();

    public abstract boolean isAPIInstalled();

    public abstract void send() throws IOException;

    public void setMetadata(Properties properties) {
        new FaxSenderPanel(this, this.md, properties).display();
    }

    public void addListener(FaxSenderListener faxSenderListener) {
        this.listeners.add(faxSenderListener);
    }

    public void fireListenerUpdate(FaxSenderMetadata.Type type) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            FaxSenderListener faxSenderListener = (FaxSenderListener)enumeration.nextElement();
            faxSenderListener.update(type, this.md);
        }
    }

    public JComponent getGUI(Properties properties) {
        return new FaxPanel(properties, this);
    }

    public static FaxSender getDevice() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Linux")) {
            FaxSender faxSender = CapiFaxSender.getDevice();
            if (faxSender.isAPIInstalled()) {
                return faxSender;
            }
        } else if (string.startsWith("Windows")) {
            FaxSender faxSender = CapiFaxSender.getDevice();
            if (faxSender.isAPIInstalled()) {
                return faxSender;
            }
        } else if (string.startsWith("Mac")) {
            // empty if block
        }
        return null;
    }
}

