/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.fax;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.device.fax.FaxCallSaver;
import uk.co.mmscomputing.imageio.sff.SFFInputStream;
import uk.co.mmscomputing.imageio.sff.SFFOutputStream;
import uk.co.mmscomputing.imageio.tiff.TIFFClassFMHOutputStream;
import uk.co.mmscomputing.imageio.tiff.TIFFClassFOutputStream;

public class FaxCallSffSaver
extends FaxCallSaver {
    public void run(String string, String string2, InputStream inputStream, OutputStream outputStream) {
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            this.filename = this.createFilePath(string, string2, "sff");
            File file = new File(this.filename);
            fileOutputStream = new FileOutputStream(file);
            String string3 = this.filename.toLowerCase();
            try {
                n = Integer.parseInt(this.properties.getProperty("uk.co.mmscomputing.device.fax.maxillegallinecodings", "-1"));
            }
            catch (Exception exception) {
                System.out.println("3\b" + this.getClass().getName() + ".run\n\tCould not set 'illegal line coding' limit.\n\t" + exception);
                n = -1;
            }
            if (string3.endsWith(".tif") || string3.endsWith(".tiff")) {
                this.writeTiff(inputStream, fileOutputStream, n);
            } else if (n >= 0) {
                this.writeSff(inputStream, fileOutputStream, n);
            } else {
                this.write(inputStream, fileOutputStream);
            }
        }
        catch (SFFInputStream.IllegalLineCodingException illegalLineCodingException) {
            System.out.println("5\b" + this.getClass().getName() + ".run\n\tDisconnect call.\n\t" + illegalLineCodingException);
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".run\n\tDisconnected call.\n\t" + exception);
            exception.printStackTrace();
        }
        try {
            inputStream.close();
            outputStream.close();
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ".run:\n\t" + exception);
        }
    }

    protected void writeSff(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        SFFInputStream sFFInputStream = new SFFInputStream(inputStream);
        SFFOutputStream sFFOutputStream = new SFFOutputStream(outputStream);
        sFFInputStream.setMaxAllowedIllegalLineCodings(n);
        while (sFFInputStream.hasImage()) {
            int n2;
            sFFOutputStream.writePageHeader(sFFInputStream.getWidth());
            byte[] byArray = new byte[256];
            while ((n2 = sFFInputStream.read(byArray)) != -1) {
                sFFOutputStream.write(byArray, 0, n2);
            }
            sFFOutputStream.writePageEnd();
        }
        sFFOutputStream.writeDocumentEnd();
    }

    public void writeTiff(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        SFFInputStream sFFInputStream = new SFFInputStream(inputStream);
        TIFFClassFMHOutputStream tIFFClassFMHOutputStream = new TIFFClassFMHOutputStream(outputStream);
        sFFInputStream.setMaxAllowedIllegalLineCodings(n);
        while (sFFInputStream.hasImage()) {
            int n2;
            ((TIFFClassFOutputStream)tIFFClassFMHOutputStream).writePageHeader(sFFInputStream.getWidth());
            byte[] byArray = new byte[256];
            while ((n2 = sFFInputStream.read(byArray)) != -1) {
                tIFFClassFMHOutputStream.write(byArray, 0, n2);
            }
            ((TIFFClassFOutputStream)tIFFClassFMHOutputStream).writePageEnd();
        }
        tIFFClassFMHOutputStream.writeDocumentEnd();
    }
}

