/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.fax;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import uk.co.mmscomputing.device.fax.FaxCallHandler;
import uk.co.mmscomputing.device.fax.FaxCallSaver;
import uk.co.mmscomputing.util.JarImageIcon;

public class FaxCallMonitor
implements FaxCallHandler {
    protected FaxCallSaver handler;

    public FaxCallMonitor(FaxCallSaver faxCallSaver) {
        this.handler = faxCallSaver;
    }

    public String getFile() {
        return this.handler.getFile();
    }

    public void init(Properties properties) {
        this.handler.init(properties);
    }

    public void run(String string, String string2, InputStream inputStream, OutputStream outputStream) {
        try {
            inputStream = new FaxCallMonitorInputStream("Save Fax from " + string2, inputStream);
            this.handler.run(string, string2, inputStream, outputStream);
        }
        catch (Exception exception) {
            System.out.println("9\b" + this.getClass().getName() + ".run\n\t" + exception);
            exception.printStackTrace();
        }
    }

    class FaxCallMonitorInputStream
    extends FilterInputStream {
        FaxCallProgressMonitor pm;
        int count;

        public FaxCallMonitorInputStream(String string, InputStream inputStream) {
            super(inputStream);
            this.pm = null;
            this.count = 0;
            this.pm = new FaxCallProgressMonitor(string);
            new Thread(this.pm).start();
        }

        public int read() throws IOException {
            int n = this.in.read();
            if (n != -1) {
                ++this.count;
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((n2 = this.in.read(byArray, n, n2)) == -1) {
                return -1;
            }
            this.count += n2;
            return n2;
        }

        public void close() {
            if (this.pm != null) {
                this.pm.close();
            }
        }

        private class FaxCallProgressMonitor
        extends JPanel
        implements Runnable,
        ActionListener {
            JFrame dialog = null;
            JProgressBar progressBar;
            JLabel note;
            JLabel msg;
            Timer timer = null;
            int time = 0;

            public FaxCallProgressMonitor(String string) {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                Border border = jPanel.getBorder();
                EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
                jPanel.setBorder(new CompoundBorder(border, emptyBorder));
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BoxLayout(jPanel2, 3));
                jPanel2.add(new JLabel(new JarImageIcon(this.getClass(), "32x32/fax.png")));
                jPanel.add((Component)jPanel2, "West");
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(new BoxLayout(jPanel3, 3));
                this.msg = new JLabel(string);
                jPanel3.add(this.msg);
                this.note = new JLabel(" ");
                jPanel3.add(this.note);
                this.progressBar = new JProgressBar();
                this.progressBar.setIndeterminate(true);
                jPanel3.add(this.progressBar);
                jPanel.add((Component)jPanel3, "East");
                this.setLayout(new BorderLayout());
                this.add((Component)jPanel, "North");
            }

            public void close() {
                this.timer.stop();
                if (this.dialog != null) {
                    this.dialog.dispose();
                }
            }

            public void run() {
                this.timer = new Timer(500, this);
                this.timer.start();
            }

            public void setNote(String string) {
                this.note.setText(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.time += this.timer.getDelay();
                if (this.time > 500) {
                    String string = "File size: " + FaxCallMonitorInputStream.this.count + " in " + this.time / 1000 + " s [" + FaxCallMonitorInputStream.this.count * 1000 / this.time + " bps]";
                    this.setNote(string);
                    if (this.dialog == null) {
                        this.msg.setText("<html>" + this.msg.getText() + "<br><i>" + FaxCallMonitor.this.getFile() + "</i></html>");
                        this.display();
                    }
                }
            }

            void display() {
                this.dialog = new JFrame("Progress...");
                this.dialog.setDefaultCloseOperation(2);
                this.setOpaque(true);
                this.dialog.setContentPane(this);
                this.dialog.pack();
                this.dialog.setLocationRelativeTo(null);
                this.dialog.setVisible(true);
                this.dialog.toFront();
            }
        }
    }
}

