/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.sound;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LawInputStream
extends FilterInputStream {
    private static byte[] inverse = null;

    public LawInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            return -1;
        }
        n = inverse[n];
        return n & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        for (int i = 0; i < n; ++i) {
            byArray[i] = inverse[byArray[i] & 0xFF];
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        n2 = this.in.read(byArray, n, n2);
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = inverse[byArray[n + i] & 0xFF];
        }
        return n2;
    }

    static {
        inverse = new byte[256];
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            LawInputStream.inverse[i] = (byte)n;
            int n2 = 256;
            while (((n ^= (n2 >>= 1)) ^ n2) > n) {
            }
        }
    }
}

