/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import uk.co.mmscomputing.device.capi.CapiCallApplication;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.plc.DisconnectInd;
import uk.co.mmscomputing.util.metadata.Metadata;
import uk.co.mmscomputing.util.metadata.MetadataListener;

public class SpeechSend
implements MetadataListener {
    CapiCallApplication appl = null;

    public SpeechSend(String string, String string2) throws IOException, UnsupportedAudioFileException {
        FileInputStream fileInputStream = new FileInputStream(string2);
        CapiMetadata capiMetadata = new CapiMetadata();
        capiMetadata.useMaxLogicalConnections(1);
        capiMetadata.useController(1);
        capiMetadata.useALaw();
        capiMetadata.use64kBit();
        capiMetadata.addListener(this);
        this.appl = new CapiCallApplication(capiMetadata);
        this.appl.start();
        try {
            System.err.println("Try connecting to " + string + ". Will wait for 100 sec.");
            CapiChannel capiChannel = this.appl.connect(string, 100000L);
            capiChannel.getInputStream().close();
            System.err.println("Connected to " + string);
            try {
                System.err.println("Try sending data to " + string);
                if (string2.endsWith(".raw")) {
                    capiChannel.writeToOutput(fileInputStream);
                } else {
                    capiChannel.writeToOutput(AudioSystem.getAudioInputStream(fileInputStream));
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
            capiChannel.close();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        ((InputStream)fileInputStream).close();
        this.appl.close();
    }

    public void update(Object object, Metadata metadata) {
        if (object instanceof DisconnectInd) {
            System.err.println("End SpeechSend.");
        } else if (object instanceof Exception) {
            System.err.println(object);
            ((Exception)object).printStackTrace();
        } else {
            System.err.println(object);
        }
    }

    public static void main(String[] stringArray) {
        System.err.println("Start SpeechSend.");
        try {
            String string = "**20";
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            String string2 = "uk/co/mmscomputing/sounds/startmsg.wav";
            if (stringArray.length > 1) {
                string2 = stringArray[1];
            }
            new SpeechSend(string, string2);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

