/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiEnumerator;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiServerApplication;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.jcapi;
import uk.co.mmscomputing.device.capi.ncc.DataB3Conf;
import uk.co.mmscomputing.device.capi.ncc.DataB3Ind;
import uk.co.mmscomputing.device.capi.plc.DisconnectInd;
import uk.co.mmscomputing.util.metadata.Metadata;
import uk.co.mmscomputing.util.metadata.MetadataListener;

public class SimpleVoiceBox
implements MetadataListener,
Runnable {
    CapiServerApplication appl;
    String phoneno;
    File dir;

    public SimpleVoiceBox(String string, File file) throws IOException {
        this.phoneno = string;
        this.dir = file;
    }

    public void run() {
        try {
            jcapi.checkInstalled();
            System.out.println("running...");
            CapiMetadata capiMetadata = new CapiMetadata();
            capiMetadata.useMaxLogicalConnections(CapiEnumerator.getNoOfBChannels());
            capiMetadata.useALaw();
            capiMetadata.use64kBit();
            capiMetadata.acceptAllCalls();
            capiMetadata.useController(1);
            capiMetadata.addListener(this);
            this.appl = new CapiServerApplication(capiMetadata);
            this.appl.start();
            while (true) {
                System.out.println("Wait for call.");
                CapiChannel capiChannel = this.appl.accept();
                capiChannel.getInputStream().close();
                try {
                    Object[] objectArray = this.dir.list(new WAVFilter());
                    Arrays.sort(objectArray);
                    for (int i = 0; i < objectArray.length; ++i) {
                        File file = new File(this.dir, (String)objectArray[i]);
                        System.err.println("Try sending file : " + file.getAbsolutePath());
                        try {
                            capiChannel.writeToOutput(AudioSystem.getAudioInputStream(file));
                            continue;
                        }
                        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                            System.err.println(unsupportedAudioFileException.getMessage());
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
                capiChannel.close();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return;
        }
    }

    public void update(Object object, Metadata metadata) {
        if (object instanceof DisconnectInd) {
            System.err.println("\nDisconnect\n\n");
        } else if (object instanceof CapiMetadata.Indication) {
            this.handleIndication((CapiMetadata.Indication)object);
        } else if (object instanceof CapiException) {
            System.err.println(object);
        } else if (object instanceof Exception) {
            ((Exception)object).printStackTrace();
        } else if (!(object instanceof DataB3Ind) && !(object instanceof DataB3Conf)) {
            System.err.println(object);
        }
    }

    public void handleIndication(CapiMetadata.Indication indication) {
        System.out.println("local  no = " + indication.localno);
        System.out.println("remote no = " + indication.remoteno);
        if (this.phoneno.equals(indication.remoteno)) {
            indication.setAccept(5000);
            System.err.println("Accept call from " + indication.remoteno);
        } else {
            indication.setIgnore();
            System.err.println("Ignore call from " + indication.remoteno);
        }
    }

    public void checkInput() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.equals("quit")) continue;
            this.appl.close();
            break;
        }
        bufferedReader.close();
    }

    public static void main(String[] stringArray) {
        String string = "**20";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        File file = new File(System.getProperty("user.home"), "mmsc");
        File file2 = new File(file, "phone");
        file2.mkdirs();
        if (stringArray.length > 1) {
            file2 = new File(stringArray[1]);
        }
        System.err.println("\nStart SimpleVoiceBox\n\taccept: " + string + "\n\tsend  : " + file2.getAbsolutePath());
        System.err.println("\n\tType 'quit' on command line to quit:)\n");
        try {
            SimpleVoiceBox simpleVoiceBox = new SimpleVoiceBox(string, file2);
            new Thread(simpleVoiceBox).start();
            simpleVoiceBox.checkInput();
            System.err.println("End SimpleVoiceBox.");
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    class WAVFilter
    implements FilenameFilter {
        WAVFilter() {
        }

        public boolean accept(File file, String string) {
            string = file + "/" + string;
            File file2 = new File(string);
            return file2.isFile() && string.endsWith(".wav");
        }
    }
}

