/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.device.capi.MsgIn;
import uk.co.mmscomputing.device.capi.MsgOut;
import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.ctrl.ConnectReq;
import uk.co.mmscomputing.device.capi.jcapi;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3ActiveInd;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3ActiveResp;
import uk.co.mmscomputing.device.capi.ncc.DataB3Conf;
import uk.co.mmscomputing.device.capi.ncc.DataB3Ind;
import uk.co.mmscomputing.device.capi.ncc.DataB3Req;
import uk.co.mmscomputing.device.capi.ncc.DataB3Resp;
import uk.co.mmscomputing.device.capi.ncc.DisconnectB3Ind;
import uk.co.mmscomputing.device.capi.ncc.DisconnectB3Req;
import uk.co.mmscomputing.device.capi.ncc.DisconnectB3Resp;
import uk.co.mmscomputing.device.capi.plc.ConnectActiveInd;
import uk.co.mmscomputing.device.capi.plc.ConnectActiveResp;
import uk.co.mmscomputing.device.capi.plc.ConnectB3Req;
import uk.co.mmscomputing.device.capi.plc.DisconnectInd;
import uk.co.mmscomputing.device.capi.plc.DisconnectReq;
import uk.co.mmscomputing.device.capi.plc.DisconnectResp;
import uk.co.mmscomputing.device.capi.protocol.SpeechProtocol;

public class SimpleSpeechSend {
    private final int BUFSIZE = 512;
    protected int appid = -1;
    private InputStream in = null;
    private Semaphore blocker = new Semaphore(7, true);
    private DataB3Req[] dataB3Reqs = new DataB3Req[8];
    private byte[][] buffers = new byte[8][512];
    private int handle = 0;
    byte[] buf = null;

    public SimpleSpeechSend() throws IOException {
        jcapi.checkInstalled();
        this.appid = jcapi.register(1, 7, 512);
    }

    private void put(MsgOut msgOut) throws IOException {
        jcapi.putMessage(this.appid, msgOut.getBytes());
    }

    public void connect(String string) throws IOException {
        int n = 1;
        int n2 = 1;
        String string2 = "";
        this.put(new ConnectReq(this.appid, n2, n, string, string2, "", "", (StructOut)new SpeechProtocol(), StructOut.empty, StructOut.empty, StructOut.empty, StructOut.empty));
    }

    public void close() throws IOException {
        jcapi.release(this.appid);
    }

    private void send(final int n) {
        new Thread(){

            public void run() {
                System.err.println("START SENDING");
                try {
                    int n2;
                    while ((n2 = SimpleSpeechSend.this.in.read(SimpleSpeechSend.this.buffers[SimpleSpeechSend.this.handle])) != -1) {
                        DataB3Req dataB3Req;
                        System.err.println("write[" + SimpleSpeechSend.this.handle + "]=" + n2 + " bytes");
                        System.err.println("write data [blocked]");
                        SimpleSpeechSend.this.blocker.acquire();
                        System.err.println("write data [released block]");
                        ((SimpleSpeechSend)SimpleSpeechSend.this).dataB3Reqs[((SimpleSpeechSend)SimpleSpeechSend.this).handle] = dataB3Req = new DataB3Req(SimpleSpeechSend.this.appid, n, SimpleSpeechSend.this.handle, 0, SimpleSpeechSend.this.buffers[SimpleSpeechSend.this.handle], n2);
                        SimpleSpeechSend.this.put(dataB3Req);
                        SimpleSpeechSend.this.handle = (SimpleSpeechSend.this.handle + 1) % 8;
                    }
                    SimpleSpeechSend.this.put(new DisconnectB3Req(SimpleSpeechSend.this.appid, n));
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    protected void handleMessage(MsgIn msgIn) throws IOException {
        if (msgIn instanceof ConnectActiveInd) {
            this.put(new ConnectActiveResp(msgIn.appid, msgIn.lineid));
            this.put(new ConnectB3Req(this.appid, msgIn.lineid));
        } else if (msgIn instanceof ConnectB3ActiveInd) {
            System.err.println("CONNECTED");
            this.put(new ConnectB3ActiveResp(msgIn.appid, msgIn.lineid));
            this.send(msgIn.lineid);
        } else if (msgIn instanceof DataB3Conf) {
            int n = ((DataB3Conf)msgIn).getHandle();
            this.dataB3Reqs[n].release();
            System.err.println("blocker [released block]");
            this.blocker.release();
        } else if (msgIn instanceof DisconnectB3Ind) {
            this.put(new DisconnectB3Resp(msgIn.appid, msgIn.lineid));
            this.put(new DisconnectReq(this.appid, msgIn.lineid));
        } else {
            if (msgIn instanceof DisconnectInd) {
                this.put(new DisconnectResp(msgIn.appid, msgIn.lineid));
                throw new IOException("Normal Disconnect");
            }
            if (msgIn instanceof DataB3Ind) {
                this.put(new DataB3Resp(msgIn.appid, msgIn.lineid, ((DataB3Ind)msgIn).getHandle()));
            } else {
                System.err.println(msgIn);
            }
        }
    }

    public void send(InputStream inputStream) {
        this.in = inputStream;
        try {
            while (true) {
                jcapi.waitForMessage(this.appid);
                this.buf = jcapi.getMessage(this.appid, this.buf);
                MsgIn msgIn = MsgIn.create(this.buf);
                this.handleMessage(msgIn);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
            try {
                this.close();
            }
            catch (IOException iOException2) {
                System.err.println(iOException2.getMessage());
            }
            return;
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "**20";
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            String string2 = "uk/co/mmscomputing/device/capi/samples/capture.raw";
            if (stringArray.length > 1) {
                string2 = stringArray[1];
            }
            System.err.println("Try to send raw isdn sound file " + string2 + " to " + string);
            SimpleSpeechSend simpleSpeechSend = new SimpleSpeechSend();
            simpleSpeechSend.connect(string);
            simpleSpeechSend.send(new FileInputStream(string2));
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }
}

