/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import uk.co.mmscomputing.device.capi.MsgIn;
import uk.co.mmscomputing.device.capi.MsgOut;
import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.ctrl.ListenReq;
import uk.co.mmscomputing.device.capi.jcapi;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3ActiveInd;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3ActiveResp;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3Ind;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3Resp;
import uk.co.mmscomputing.device.capi.ncc.DataB3Ind;
import uk.co.mmscomputing.device.capi.ncc.DataB3Resp;
import uk.co.mmscomputing.device.capi.ncc.DisconnectB3Ind;
import uk.co.mmscomputing.device.capi.ncc.DisconnectB3Resp;
import uk.co.mmscomputing.device.capi.parameter.AdditionalInfo;
import uk.co.mmscomputing.device.capi.plc.ConnectActiveInd;
import uk.co.mmscomputing.device.capi.plc.ConnectActiveResp;
import uk.co.mmscomputing.device.capi.plc.ConnectInd;
import uk.co.mmscomputing.device.capi.plc.ConnectResp;
import uk.co.mmscomputing.device.capi.plc.DisconnectInd;
import uk.co.mmscomputing.device.capi.plc.DisconnectResp;
import uk.co.mmscomputing.device.capi.protocol.SpeechProtocol;
import uk.co.mmscomputing.device.capi.q931.UserUser;

public class SimpleSpeechReceive {
    protected int appid = -1;
    protected int lineid = 1;
    private Vector buffers = null;
    byte[] buf = null;

    public SimpleSpeechReceive() throws IOException {
        jcapi.checkInstalled();
        this.appid = jcapi.register(1, 7, 512);
        this.buffers = new Vector();
    }

    private void put(MsgOut msgOut) throws IOException {
        jcapi.putMessage(this.appid, msgOut.getBytes());
    }

    public void close() throws IOException {
        jcapi.release(this.appid);
    }

    protected void receive(DataB3Ind dataB3Ind) throws IOException {
        byte[] byArray = dataB3Ind.getPayload(null);
        this.put(new DataB3Resp(dataB3Ind.appid, dataB3Ind.lineid, dataB3Ind.getHandle()));
        this.buffers.add(byArray);
        System.err.println(".");
    }

    public byte[] read() throws IOException {
        if (this.buffers.size() != 0) {
            byte[] byArray = (byte[])this.buffers.firstElement();
            this.buffers.removeElementAt(0);
            return byArray;
        }
        return null;
    }

    protected synchronized void indicateCall(ConnectInd connectInd) throws IOException {
        System.err.println("local number " + connectInd.getLocalNo());
        System.err.println("remote number " + connectInd.getRemoteNo());
        UserUser.Out out = new UserUser.Out("hi");
        AdditionalInfo.Out out2 = new AdditionalInfo.Out(out);
        this.put(new ConnectResp(this.appid, connectInd.lineid, 0, (StructOut)new SpeechProtocol(), connectInd.getLocalNo(), "", StructOut.empty, (StructOut)out2));
    }

    protected void handleMessage(MsgIn msgIn) throws IOException {
        if (msgIn instanceof ConnectInd) {
            this.indicateCall((ConnectInd)msgIn);
        } else if (msgIn instanceof ConnectActiveInd) {
            this.put(new ConnectActiveResp(msgIn.appid, msgIn.lineid));
        } else if (msgIn instanceof ConnectB3Ind) {
            this.put(new ConnectB3Resp(this.appid, msgIn.lineid));
        } else if (msgIn instanceof ConnectB3ActiveInd) {
            this.put(new ConnectB3ActiveResp(msgIn.appid, msgIn.lineid));
            this.lineid = msgIn.lineid;
            this.buffers.clear();
        } else if (msgIn instanceof DataB3Ind) {
            this.receive((DataB3Ind)msgIn);
        } else if (msgIn instanceof DisconnectB3Ind) {
            this.put(new DisconnectB3Resp(msgIn.appid, msgIn.lineid));
        } else {
            if (msgIn instanceof DisconnectInd) {
                this.put(new DisconnectResp(msgIn.appid, msgIn.lineid));
                throw new IOException("Normal Disconnect");
            }
            System.err.println(msgIn);
        }
    }

    protected void waitForMessage() throws IOException {
        jcapi.waitForMessage(this.appid);
        this.buf = jcapi.getMessage(this.appid, this.buf);
        MsgIn msgIn = MsgIn.create(this.buf);
        this.handleMessage(msgIn);
    }

    public void save(OutputStream outputStream) throws IOException {
        byte[] byArray;
        while ((byArray = this.read()) != null) {
            outputStream.write(byArray);
        }
        outputStream.close();
    }

    public void receive(OutputStream outputStream) throws IOException {
        this.put(new ListenReq(this.appid, this.lineid));
        try {
            while (true) {
                this.waitForMessage();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            try {
                this.close();
            }
            catch (IOException iOException2) {
                System.err.println(iOException2.getMessage());
            }
            this.save(outputStream);
            return;
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "uk/co/mmscomputing/device/capi/samples/capture.raw";
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            SimpleSpeechReceive simpleSpeechReceive = new SimpleSpeechReceive();
            simpleSpeechReceive.receive(new FileOutputStream(string));
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }
}

