/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.mmscomputing.device.capi.CapiApplication;
import uk.co.mmscomputing.device.capi.CapiCallApplication;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiOutputStream;
import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.ctrl.ConnectReq;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;

public class SimpleModemDataSender {
    private CapiCallApplication capi = null;

    public SimpleModemDataSender(CapiCallApplication capiCallApplication) throws IOException {
        this.capi = capiCallApplication;
    }

    public void send(String string, File file) {
        try {
            int n;
            BProtocol bProtocol = new BProtocol(8, 1, 7, StructOut.empty, StructOut.empty, StructOut.empty, StructOut.empty);
            int n2 = 1;
            int n3 = 4;
            ConnectReq connectReq = new ConnectReq(this.capi.getApplID(), n2, n3, string, "", "", "", bProtocol);
            CapiChannel capiChannel = this.capi.connect(connectReq, 120000L);
            System.err.println("Connection successful.");
            InputStream inputStream = new FileInputStream(file);
            int n4 = (int)file.length();
            CapiOutputStream capiOutputStream = capiChannel.getOutputStream();
            System.out.println("File size is : " + n4 + "[0x" + Integer.toHexString(n4) + "] bytes");
            byte[] byArray = new byte[]{(byte)(n4 >> 24 & 0xFF), (byte)(n4 >> 16 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 >> 0 & 0xFF)};
            ((OutputStream)capiOutputStream).write(byArray, 0, 4);
            int n5 = n4;
            byte[] byArray2 = new byte[512];
            while ((n = inputStream.read(byArray2)) != -1) {
                System.err.println("send " + n + " [0x" + Integer.toHexString(n) + "] => left to send : " + (n5 -= n));
                ((OutputStream)capiOutputStream).write(byArray2, 0, n);
            }
            inputStream.close();
            inputStream = capiChannel.getInputStream();
            n5 = inputStream.read() & 0xFF;
            n5 |= (inputStream.read() & 0xFF) << 8;
            n5 |= (inputStream.read() & 0xFF) << 16;
            System.err.println("peer received " + (n5 |= (inputStream.read() & 0xFF) << 24) + " bytes");
            if (n4 == n5) {
                System.err.println("Successful Transfer");
            } else {
                System.err.println("Unsuccessful Transfer " + n4 + " " + n5);
            }
            capiChannel.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        CapiApplication capiApplication = null;
        try {
            String string = "**30";
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            String string2 = "uk/co/mmscomputing/test.txt";
            if (stringArray.length > 1) {
                string2 = stringArray[1];
            }
            System.err.println("Try to send file " + string2 + " to " + string);
            CapiMetadata capiMetadata = new CapiMetadata();
            capiMetadata.useMaxLogicalConnections(1);
            capiMetadata.useController(1);
            capiMetadata.useALaw();
            capiMetadata.use64kBit();
            capiApplication = new CapiCallApplication(capiMetadata);
            capiApplication.start();
            SimpleModemDataSender simpleModemDataSender = new SimpleModemDataSender((CapiCallApplication)capiApplication);
            simpleModemDataSender.send(string, new File(string2));
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        finally {
            if (capiApplication != null) {
                capiApplication.close();
            }
        }
    }
}

