/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.FileInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import uk.co.mmscomputing.device.capi.sound.LawInputStream;
import uk.co.mmscomputing.device.capi.sound.PCMInputStream;
import uk.co.mmscomputing.sound.ConvertInputStream;
import uk.co.mmscomputing.sound.WaveOutputFile;

public class Raw2WaveConverter {
    public static final AudioFormat pcmformat = new AudioFormat(8000.0f, 16, 1, true, false);
    public static final AudioFormat alawformat = new AudioFormat(AudioFormat.Encoding.ALAW, 8000.0f, 8, 1, 1, 8000.0f, false);
    public static final AudioFormat ulawformat = new AudioFormat(AudioFormat.Encoding.ULAW, 8000.0f, 8, 1, 1, 8000.0f, false);

    public static void main(String[] stringArray) {
        byte[] byArray;
        int n;
        WaveOutputFile waveOutputFile;
        InputStream inputStream;
        try {
            inputStream = new FileInputStream("uk/co/mmscomputing/device/capi/samples/capture.raw");
            inputStream = new PCMInputStream(inputStream, true);
            waveOutputFile = new WaveOutputFile("uk/co/mmscomputing/device/capi/samples/capturePCM.wav", pcmformat);
            n = 0;
            byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) > 0) {
                waveOutputFile.write(byArray, 0, n);
            }
            waveOutputFile.close();
            inputStream = new FileInputStream("uk/co/mmscomputing/device/capi/samples/capturePCM.wav");
            for (int i = 0; i < 58; ++i) {
                int n2 = inputStream.read();
                System.err.println("[" + i + "] " + n2 + " 0x" + Integer.toHexString(n2) + " " + (char)n2);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        try {
            inputStream = new FileInputStream("uk/co/mmscomputing/device/capi/samples/capture.raw");
            inputStream = new LawInputStream(inputStream);
            waveOutputFile = new WaveOutputFile("uk/co/mmscomputing/device/capi/samples/captureALaw.wav", alawformat);
            n = 0;
            byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) > 0) {
                waveOutputFile.write(byArray, 0, n);
            }
            waveOutputFile.close();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        try {
            inputStream = new FileInputStream("uk/co/mmscomputing/device/capi/samples/capture.raw");
            inputStream = new LawInputStream(inputStream);
            inputStream = new ConvertInputStream(inputStream, true);
            waveOutputFile = new WaveOutputFile("uk/co/mmscomputing/device/capi/samples/captureuLaw.wav", ulawformat);
            n = 0;
            byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) > 0) {
                waveOutputFile.write(byArray, 0, n);
            }
            waveOutputFile.close();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

