/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiPlugin;
import uk.co.mmscomputing.device.capi.CapiSystem;
import uk.co.mmscomputing.device.capi.protocol.FaxBProtocol;
import uk.co.mmscomputing.util.metadata.Metadata;

public class FaxReceiver
implements CapiPlugin {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_");
    private File faxdir;

    public FaxReceiver() {
        File file = new File(System.getProperty("user.home"), "mmsc");
        this.faxdir = new File(file, "fax" + File.separator + "rec");
        this.faxdir.mkdirs();
    }

    public void update(Object object, Metadata metadata) {
        CapiMetadata.Indication indication;
        if (object instanceof CapiMetadata.Indication && !(indication = (CapiMetadata.Indication)object).isAccepted()) {
            try {
                indication.setPlugin(this);
                indication.setProtocol(new FaxBProtocol(0, 0, "", ""));
                indication.setAccept(0);
                System.out.println("ACCEPTED CALL for " + indication.localno + " from " + indication.remoteno);
            }
            catch (Exception exception) {
                System.out.println("9\b" + this.getClass().getName() + ".update\n\t" + exception);
                System.err.println(this.getClass().getName() + ".update\n\t" + exception);
                exception.printStackTrace();
            }
        }
    }

    public void serve(CapiChannel capiChannel) {
        new FaxThread(capiChannel).start();
    }

    public void checkInput() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.equals("quit")) continue;
            CapiSystem.getSystem().close();
            break;
        }
        bufferedReader.close();
    }

    public static void main(String[] stringArray) {
        System.err.println("\nSTART FaxReceiver\n");
        try {
            FaxReceiver faxReceiver = new FaxReceiver();
            CapiSystem.getSystem().addPlugin(faxReceiver);
            faxReceiver.checkInput();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        System.err.println("\nFINISHED FaxReceiver\n");
    }

    private class FaxThread
    extends Thread {
        private CapiChannel channel;

        public FaxThread(CapiChannel capiChannel) {
            this.channel = capiChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.channel.getOutputStream().close();
                String string = this.channel.getRemoteNo();
                string = string.replaceAll("\\*\\*", "");
                String string2 = this.channel.getLocalNo() + "_" + string;
                File file = new File(FaxReceiver.this.faxdir, sdf.format(new Date()) + string2 + ".sff");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                System.out.println("START RECEIVING " + file.getName());
                this.channel.writeInputTo(fileOutputStream);
                fileOutputStream.close();
                System.out.println("RECEIVED " + file.getName());
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ".run\n\tDisconnected call.\n\t" + exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    this.channel.close();
                }
                catch (Exception exception) {
                    System.out.println(this.getClass().getName() + ".run:\n\t" + exception);
                    System.out.println(this.getClass().getName() + ".run:\n\t" + exception);
                }
            }
        }
    }
}

