/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import uk.co.mmscomputing.device.capi.CapiCallApplication;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiEnumerator;
import uk.co.mmscomputing.device.capi.CapiFaxDetector;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiServerApplication;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.facility.DTMFInd;
import uk.co.mmscomputing.device.capi.parameter.NCPI;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;
import uk.co.mmscomputing.device.capi.protocol.SpeechProtocol;
import uk.co.mmscomputing.util.JarFile;
import uk.co.mmscomputing.util.metadata.Metadata;
import uk.co.mmscomputing.util.metadata.MetadataListener;

public class AnswerPhone
implements MetadataListener,
Runnable {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_");
    private CapiMetadata md;
    private File voicedir;
    private File faxdir;
    private CapiServerApplication server = null;

    public AnswerPhone() throws IOException {
        File file = new File(System.getProperty("user.home"), "mmsc");
        this.voicedir = new File(file, "phone");
        this.voicedir.mkdirs();
        this.faxdir = new File(file, "fax" + File.separator + "received");
        this.faxdir.mkdirs();
        this.md = new CapiMetadata();
        this.md.useMaxLogicalConnections(CapiEnumerator.getNoOfBChannels());
        this.md.useALaw();
        this.md.use64kBit();
        this.md.acceptAllCalls();
        this.md.useController(2);
        this.md.useLocalNo("0123456789");
        this.md.useFaxHeader("my mmsc fax machine :) ");
        this.md.putInt("pickupTime", 3000);
        this.md.putInt("recordTime", 20000);
        this.md.putInt("timeout", 30000);
        this.md.putString("startmsg", "uk/co/mmscomputing/sounds/startmsg.wav");
        this.md.putString("endmsg", "uk/co/mmscomputing/sounds/endmsg.wav");
        this.md.addListener(this);
        System.out.println("create server...");
        this.server = new CapiServerApplication(this.md);
        new Thread(this.server).start();
    }

    private void send(final CapiCallApplication capiCallApplication, final String string, final String string2) {
        new Thread(){

            public void run() {
                try {
                    int n = AnswerPhone.this.md.getInt("timeout");
                    CapiChannel capiChannel = capiCallApplication.connect(string, (long)n);
                    AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new File(string2));
                    capiChannel.writeToOutput(audioInputStream);
                    audioInputStream.close();
                    capiChannel.close();
                    System.out.println("CLOSED SEND WRITE THREAD");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    private void answer(final CapiChannel capiChannel, final File file) {
        final Thread[] threadArray = new Thread[2];
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.currentThread().setName(this.getClass().getName() + ".startmsg.0x" + Integer.toHexString(capiChannel.getLineID()));
                AudioInputStream audioInputStream = null;
                try {
                    JarFile jarFile = new JarFile(AnswerPhone.this.md.getString("startmsg"));
                    audioInputStream = AudioSystem.getAudioInputStream(jarFile);
                    capiChannel.writeToOutput(audioInputStream);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    try {
                        capiChannel.close();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
                finally {
                    try {
                        if (audioInputStream != null) {
                            audioInputStream.close();
                        }
                        System.err.println("STOPPED STARTMSG 0x" + Integer.toHexString(capiChannel.getLineID()));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }.start();
        threadArray[1] = new CapiFaxDetector(capiChannel);
        threadArray[1].start();
        threadArray[0] = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.currentThread().setName(this.getClass().getName() + ".wait_endmsg.0x" + Integer.toHexString(capiChannel.getLineID()));
                AudioInputStream audioInputStream = null;
                try {
                    3.sleep(AnswerPhone.this.md.getInt("recordTime"));
                    System.err.println("STOPPED SLEEPING 0x" + Integer.toHexString(capiChannel.getLineID()));
                    JarFile jarFile = new JarFile(AnswerPhone.this.md.getString("endmsg"));
                    audioInputStream = AudioSystem.getAudioInputStream(jarFile);
                    capiChannel.writeToOutput(audioInputStream);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("INTERRUPTED CHANNEL 0x" + Integer.toHexString(capiChannel.getLineID()));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    try {
                        if (audioInputStream != null) {
                            audioInputStream.close();
                        }
                        System.err.println("ANSWERPHONE CLOSE CHANNEL 0x" + Integer.toHexString(capiChannel.getLineID()));
                        capiChannel.close();
                        System.err.println("ANSWERPHONE CLOSED CHANNEL 0x" + Integer.toHexString(capiChannel.getLineID()));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        threadArray[0].start();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AudioInputStream audioInputStream = null;
                Thread.currentThread().setName(this.getClass().getName() + ".record.0x" + Integer.toHexString(capiChannel.getLineID()));
                try {
                    audioInputStream = capiChannel.getAudioInputStream();
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, file);
                    audioInputStream.close();
                    System.err.println("STOPPED RECORDING 0x" + Integer.toHexString(capiChannel.getLineID()));
                    threadArray[0].interrupt();
                    threadArray[1].interrupt();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    try {
                        if (audioInputStream != null) {
                            audioInputStream.close();
                        }
                        capiChannel.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void receivefax(final CapiChannel capiChannel, final File file) {
        new Thread(){

            public void run() {
                try {
                    capiChannel.writeInputTo(new FileOutputStream(file));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    public void update(Object object, Metadata metadata) {
        if (object instanceof DTMFInd) {
            System.out.println(this.getClass().getName() + ".update : \n\tRECEIVED DTMF DIGITS : " + ((DTMFInd)object).getDigits());
        } else if (object instanceof NCPI) {
            System.out.println(this.getClass().getName() + ".update : \n\tRECEIVED NCPI\n" + object);
        } else if (object instanceof CapiMetadata.Indication) {
            this.handleIndication((CapiMetadata.Indication)object);
        } else if (object instanceof CapiException) {
            System.out.println(object);
        } else if (object instanceof Exception) {
            System.out.println(object);
            ((Exception)object).printStackTrace();
        } else {
            System.err.println(object);
        }
    }

    public void handleIndication(CapiMetadata.Indication indication) {
        System.out.println("local  no = " + indication.localno);
        System.out.println("remote no = " + indication.remoteno);
        indication.setAccept(this.md.getInt("pickupTime"));
    }

    public void run() {
        Thread.currentThread().setName(this.getClass().getName());
        System.out.println("Started running...");
        try {
            while (true) {
                System.out.println("wait for call...");
                CapiChannel capiChannel = this.server.accept();
                if (capiChannel != null) {
                    BProtocol bProtocol = capiChannel.getProtocol();
                    String string = capiChannel.getRemoteNo();
                    string = string.replaceAll("\\*\\*", "");
                    String string2 = capiChannel.getLocalNo() + "_" + string;
                    if (bProtocol instanceof SpeechProtocol) {
                        this.answer(capiChannel, new File(this.voicedir, sdf.format(new Date()) + string2 + ".wav"));
                        continue;
                    }
                    this.receivefax(capiChannel, new File(this.faxdir, sdf.format(new Date()) + string2 + ".sff"));
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("Stopped running...");
    }

    public void close() {
        this.server.close();
    }

    private static void RedirectSystemOut(String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            System.setOut(printStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void showThreads() throws InterruptedException {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        int n = threadGroup.activeCount();
        Thread[] threadArray = new Thread[n];
        n = threadGroup.enumerate(threadArray);
        System.err.println("\n\n\nThread group count = " + n);
        for (int i = 0; i < n; ++i) {
            System.err.println("Thread name = " + threadArray[i].getName());
            System.err.println("Thread class name = " + threadArray[i].getClass().getName());
            if (threadArray[i].getName().startsWith("main")) continue;
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            AnswerPhone answerPhone = new AnswerPhone();
            new Thread(answerPhone).start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            while ((string = bufferedReader.readLine()) != null) {
                System.out.println("input: " + string);
                if (!string.equals("quit")) continue;
                AnswerPhone.showThreads();
                answerPhone.close();
                break;
            }
            bufferedReader.close();
            System.out.println("Stopped Answerphone.");
            AnswerPhone.showThreads();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

