/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.samples;

import java.io.IOException;
import uk.co.mmscomputing.device.capi.MsgIn;
import uk.co.mmscomputing.device.capi.MsgOut;
import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.jcapi;
import uk.co.mmscomputing.device.capi.man.avm.AVMDTraceInd;
import uk.co.mmscomputing.device.capi.man.avm.AVMDTraceReq;
import uk.co.mmscomputing.device.capi.man.avm.AVMResp;
import uk.co.mmscomputing.device.capi.q931.Q931Message;

public class AVMDChannelTracer
implements Runnable {
    private boolean running = false;
    protected int appid = -1;
    protected int lineid = 1;
    public static final int RR = 1;
    public static final int RNR = 5;
    public static final int REJ = 9;
    public static final int SABME = 111;
    public static final int DM = 15;
    public static final int UI = 3;
    public static final int DISC = 67;
    public static final int UA = 99;
    public static final int FRMR = 135;
    public static final int XID = 175;
    byte[] buf = null;

    public AVMDChannelTracer() throws IOException {
        jcapi.checkInstalled();
        this.appid = jcapi.register(1, 2, 128);
    }

    private void put(MsgOut msgOut) throws IOException {
        jcapi.putMessage(this.appid, msgOut.getBytes());
    }

    protected void handleMessage(MsgIn msgIn) throws IOException {
        if (msgIn instanceof AVMDTraceInd) {
            int n;
            AVMDTraceInd aVMDTraceInd = (AVMDTraceInd)msgIn;
            this.put(new AVMResp(this.appid, this.lineid, aVMDTraceInd.getClassId(), aVMDTraceInd.getFunctionId(), StructOut.empty));
            byte[] byArray = aVMDTraceInd.getBytes();
            Rider rider = new Rider(byArray);
            System.out.println(rider.toString());
            rider.read();
            rider.read();
            int n2 = rider.read();
            int n3 = n2 >> 1 & 1;
            n2 >>= 2;
            int n4 = rider.read();
            n4 >>= 1;
            int n5 = rider.read();
            int n6 = 0;
            int n7 = 0;
            if ((n5 & 3) == 3) {
                n = n5 & 0x10;
                n5 &= 0xFFFFFFEF;
            } else {
                n6 = rider.read();
                n = n6 & 1;
                n6 >>= 1;
            }
            System.out.println("lapd: cr=" + n3 + " sapi=" + n2 + " tei=" + n4 + " ctl=0x" + Integer.toHexString(n5) + " pf=" + n);
            switch (n2) {
                case 0: {
                    System.out.println(" Frame is transporting signaling information ");
                    break;
                }
                case 1: {
                    System.out.println(" Frame is carrying data for the Q.931 packet mode data ");
                    break;
                }
                case 16: {
                    System.out.println(" Frame is carrying data for the X.25 packet-mode data ");
                    break;
                }
                case 62: {
                    System.out.println(" Frame for test or recovery ");
                    break;
                }
                case 63: {
                    System.out.println(" Frame is used for management purpose ");
                }
            }
            switch (n5) {
                case 1: {
                    System.out.println(" RR  - Receiver Ready nr=" + n6);
                    break;
                }
                case 5: {
                    System.out.println(" RNR - Receiver Not Ready nr=" + n6);
                    break;
                }
                case 9: {
                    System.out.println(" REJ - Reject nr=" + n6);
                    break;
                }
                case 111: {
                    System.out.println(" SABME - Set Asynchronous Balanced Mode Extended ");
                    break;
                }
                case 15: {
                    System.out.println(" DM    - Disconnect Mode ");
                    break;
                }
                case 3: {
                    System.out.println(" UI    - Unnumbered Information ");
                    break;
                }
                case 67: {
                    System.out.println(" DISC  - Disconnect ");
                    break;
                }
                case 99: {
                    System.out.println(" UA    - Unnumbered Acknowledgement ");
                    break;
                }
                case 135: {
                    System.out.println(" FRMR  - Frame Reject ");
                    break;
                }
                case 175: {
                    System.out.println(" XID   - Exchange Identification ");
                }
            }
            if ((n5 & 1) == 0) {
                n7 = n5 >> 1;
                System.out.println(" Information Format nr=" + n6 + " ns=" + n7);
            }
            try {
                Q931Message q931Message = Q931Message.create(rider);
                System.out.println(q931Message.toString());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.out.println(msgIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        try {
            this.put(new AVMDTraceReq.Start(this.appid, this.lineid));
            while (this.running) {
                jcapi.waitForMessage(this.appid);
                this.buf = jcapi.getMessage(this.appid, this.buf);
                MsgIn msgIn = MsgIn.create(this.buf);
                this.handleMessage(msgIn);
            }
            this.put(new AVMDTraceReq.Stop(this.appid, this.lineid));
            jcapi.waitForMessage(this.appid);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        finally {
            try {
                jcapi.release(this.appid);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            AVMDChannelTracer aVMDChannelTracer = new AVMDChannelTracer();
            new Thread(aVMDChannelTracer).start();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

