/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.q931;

import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.q931.Q931;

public class ProgressIndicator
extends Q931 {
    public int codingStandard = 0;
    public int location = 0;
    public int progressDescription = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressIndicator(Rider rider) {
        rider.setLength();
        try {
            int n = rider.read();
            this.codingStandard = ProgressIndicator.getBits(n, 7, 6);
            this.location = ProgressIndicator.getBits(n, 4, 1);
            if (this.codingStandard != 0) {
                throw new IllegalArgumentException();
            }
            n = rider.read();
            this.progressDescription = ProgressIndicator.getBits(n, 7, 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            rider.skip();
        }
    }

    public ProgressIndicator(byte[] byArray) {
        this(new Rider(byArray));
    }

    public String toString() {
        String string = "Progress Indicator - ";
        switch (this.location) {
            case 0: {
                string = string + "\n    Location: User";
                break;
            }
            case 1: {
                string = string + "\n    Location: Private network serving the local user";
                break;
            }
            case 2: {
                string = string + "\n    Location: Public network serving the local user";
                break;
            }
            case 3: {
                string = string + "\n    Location: Transit network";
                break;
            }
            case 4: {
                string = string + "\n    Location: Public network serving the remote user";
                break;
            }
            case 5: {
                string = string + "\n    Location: Private network serving the remote user";
                break;
            }
            case 6: {
                string = string + "\n    Location: Network beyond interworking point";
            }
        }
        switch (this.progressDescription) {
            case 1: {
                string = string + "\n    Progress Description: Call is not end-to-end ISDN";
                break;
            }
            case 2: {
                string = string + "\n    Progress Description: Destination address is non ISDN";
                break;
            }
            case 3: {
                string = string + "\n    Progress Description: Origination address is non ISDN";
                break;
            }
            case 4: {
                string = string + "\n    Progress Description: Call has returned to the ISDN";
                break;
            }
            case 5: {
                string = string + "\n    Progress Description: Interworking has occurred and has resulted in a telecommunication service change.";
                break;
            }
            case 8: {
                string = string + "\n    Progress Description: Inband information or appropriate pattern now available";
            }
        }
        return string;
    }
}

