/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.q931;

import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.q931.Q931;

public class HighLayerCompatibility
extends Q931 {
    public int codingStandard = -1;
    public int interpretation = -1;
    public int presentation = -1;
    public int characteristics = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighLayerCompatibility(Rider rider) {
        rider.setLength();
        try {
            int n = rider.read();
            this.codingStandard = HighLayerCompatibility.getBits(n, 7, 6);
            if (this.codingStandard != 0) {
                throw new IllegalArgumentException();
            }
            this.interpretation = HighLayerCompatibility.getBits(n, 5, 3);
            this.presentation = HighLayerCompatibility.getBits(n, 2, 1);
            n = rider.read();
            this.characteristics = HighLayerCompatibility.getBits(n, 7, 1);
            if (HighLayerCompatibility.isExt(n)) {
                n = rider.read();
                this.characteristics = HighLayerCompatibility.getBits(n, 7, 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            rider.skip();
        }
    }

    public HighLayerCompatibility(byte[] byArray) {
        this(new Rider(byArray));
    }

    public String toString() {
        String string = "High Layer compatibility - ";
        switch (this.characteristics) {
            case -1: {
                break;
            }
            case 1: {
                string = string + "\n    Characteristics: Telephony";
                break;
            }
            case 4: {
                string = string + "\n    Characteristics: Facsimile Group 2/3";
                break;
            }
            case 33: {
                string = string + "\n    Characteristics: Facsimile Group 4 Class I";
                break;
            }
            case 36: {
                string = string + "\n    Characteristics: Teletex service, Group 4 Classes II and III";
                break;
            }
            default: {
                string = string + "\n    Characteristics: [" + Integer.toHexString(this.characteristics) + "]";
            }
        }
        return string;
    }
}

