/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.q931;

import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.q931.Q931;

public class CalledPartySubAddress
extends Q931 {
    private int typeOfSubAddress = -1;
    private int oddeven = -1;
    private String digits = "";
    private int AFI = 80;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalledPartySubAddress(Rider rider) {
        rider.setLength();
        try {
            int n = rider.read();
            this.typeOfSubAddress = CalledPartySubAddress.getBits(n, 7, 5);
            if (this.typeOfSubAddress == 0) {
                this.AFI = rider.read();
                if (this.AFI != 80) {
                    System.err.println("CalledPartySubAddress.decode: Unexpected AFI field = " + this.AFI);
                }
                this.digits = rider.readString();
            } else if (this.typeOfSubAddress == 1) {
                this.oddeven = CalledPartySubAddress.getBits(n, 4, 4);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            rider.skip();
        }
    }

    public CalledPartySubAddress(byte[] byArray) {
        this(new Rider(byArray));
    }

    public String getNumber() {
        return this.digits;
    }

    public String toString() {
        String string = super.toString();
        string = string + "Type of sub address                    = " + this.typeOfSubAddress + "\n";
        string = string + "Authority and Format Identifier        = " + this.AFI + "\n";
        string = string + "Digits                                 = " + this.digits + "\n";
        return string;
    }

    public static class Out
    extends StructOut {
        public Out(String string) {
            super(2 + string.length());
            this.writeByte(128);
            this.writeByte(80);
            this.writeData(string.getBytes(), 0, string.length());
        }
    }
}

