/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.ncc;

import uk.co.mmscomputing.device.capi.MsgOut;
import uk.co.mmscomputing.device.capi.jcapi;

public class DataB3Req
extends MsgOut {
    private int nptr = 0;
    private int handle;
    private int nlen;
    private int flags;
    private long n64ptr = 0L;
    private byte[] payload;

    private static int getStructSize(int n) {
        if (jcapi.ptrSize == 4) {
            return 10;
        }
        if (jcapi.ptrSize == 8) {
            return 18;
        }
        return 18 + n;
    }

    public DataB3Req(int n, int n2, int n3, int n4, byte[] byArray, int n5) {
        super(DataB3Req.getStructSize(n5), n, 134, 128, n2);
        if (jcapi.ptrSize == 4) {
            this.nptr = jcapi.acquireNative32bitDataPtr(byArray);
            this.writeDWord(this.nptr);
            this.writeWord(n5);
            this.writeWord(n3);
            this.writeWord(n4);
        } else if (jcapi.ptrSize == 8) {
            this.n64ptr = jcapi.acquireNative64bitDataPtr(byArray);
            this.writeDWord(0);
            this.writeWord(n5);
            this.writeWord(n3);
            this.writeWord(n4);
            this.writeQWord(this.n64ptr);
        } else {
            this.writeDWord(0);
            this.writeWord(n5);
            this.writeWord(n3);
            this.writeWord(n4);
            this.writeQWord(0L);
            this.writeData(byArray, 0, n5);
        }
        this.handle = n3;
        this.nlen = n5;
        this.flags = n4;
        this.payload = byArray;
    }

    public void release() {
        if (this.nptr != 0) {
            jcapi.releaseNative32bitDataPtr(this.payload, this.nptr);
            this.nptr = 0;
        } else if (this.n64ptr != 0L) {
            jcapi.releaseNative64bitDataPtr(this.payload, this.n64ptr);
            this.n64ptr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public String toString() {
        String string = super.toString();
        string = this.n64ptr != 0L ? string + "n64ptr   = 0x" + Long.toHexString(this.n64ptr) + "\n" : string + "nptr     = 0x" + Integer.toHexString(this.nptr) + "\n";
        string = string + "nlen     = " + this.nlen + "\n";
        string = string + "handle   = " + this.handle + "\n";
        string = string + "flags    = 0" + Integer.toBinaryString(this.flags) + "b\n";
        return string;
    }

    public int getHandle() {
        return this.handle;
    }

    public byte[] getData() {
        return this.payload;
    }
}

