/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.man.eicon;

import javax.swing.tree.DefaultMutableTreeNode;
import uk.co.mmscomputing.device.capi.CapiProfile;

public class EiconProfile
extends CapiProfile {
    private int specOptions;
    public static final String[] specOptionStrings = new String[]{"", "", "", "", "", "Extended DTMF tone detection and generation support", "Extended Fax paper formats and resolution support", "Extended modem configuration support", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};

    public EiconProfile(byte[] byArray) {
        super(byArray);
        this.specOptions = byArray[44] & 0xFF | (byArray[45] & 0xFF) << 8 | (byArray[46] & 0xFF) << 16 | (byArray[47] & 0xFF) << 24;
    }

    public boolean isSupportingExtendedDTMF() {
        return this.checkBit(this.specOptions, 5);
    }

    public boolean isSupportingExtendedFaxFormat() {
        return this.checkBit(this.specOptions, 6);
    }

    public boolean isSupportingExtendedModemConfiguration() {
        return this.checkBit(this.specOptions, 7);
    }

    public String toString() {
        String string = super.toString();
        string = string + "\nEicon Spec Options = 0" + Integer.toBinaryString(this.specOptions) + "b\n";
        for (int i = 0; i < specOptionStrings.length; ++i) {
            if (!this.checkBit(this.specOptions, i)) continue;
            string = string + "Bit[" + i + "] - " + specOptionStrings[i] + "\n";
        }
        return string;
    }

    public DefaultMutableTreeNode toTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = super.toTree();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Eicon Specific Options : 0" + Integer.toBinaryString(this.specOptions) + "b");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (int i = 0; i < specOptionStrings.length; ++i) {
            if (!this.checkBit(this.specOptions, i)) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Bit[" + i + "] - " + specOptionStrings[i]));
        }
        return defaultMutableTreeNode;
    }
}

