/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.facility;

import uk.co.mmscomputing.device.capi.MsgIn;
import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.exception.CapiIOException;
import uk.co.mmscomputing.device.capi.facility.CallDeflectionInd;
import uk.co.mmscomputing.device.capi.facility.CallForwardInd;
import uk.co.mmscomputing.device.capi.facility.FacilityInd;

public class SupServiceInd
extends FacilityInd {
    protected int function;

    public SupServiceInd(Rider rider) {
        super(rider);
        this.function = rider.readWord();
        rider.structBegin();
    }

    public static MsgIn create(Rider rider) {
        int n = rider.readWord();
        rider.structBegin();
        switch (n) {
            case 2: {
                return new HoldInd(rider);
            }
            case 3: {
                return new RetrieveInd(rider);
            }
            case 6: {
                return new ECTInd(rider);
            }
            case 9: {
                return new CallForwardInd.ActivateInd(rider);
            }
            case 10: {
                return new CallForwardInd.DeactivateInd(rider);
            }
            case 11: {
                return new CallForwardInd.InterrogateParametersInd(rider);
            }
            case 12: {
                return new CallForwardInd.InterrogateNumbersInd(rider);
            }
            case 13: {
                return new CallDeflectionInd(rider);
            }
        }
        throw new IllegalArgumentException();
    }

    public static class ECTInd
    extends SupServiceInd {
        private int reason;

        public ECTInd(Rider rider) {
            super(rider);
            this.reason = rider.readWord();
        }

        public int getReason() {
            return this.reason;
        }

        public String toString() {
            String string = super.toString();
            string = string + "reason   = 0x" + Integer.toHexString(this.reason) + " - " + CapiIOException.capiInfo2Str(this.reason) + "\n";
            return string;
        }
    }

    public static class RetrieveInd
    extends SupServiceInd {
        private int reason;

        public RetrieveInd(Rider rider) {
            super(rider);
            this.reason = rider.readWord();
        }

        public int getReason() {
            return this.reason;
        }

        public String toString() {
            String string = super.toString();
            string = string + "reason   = 0x" + Integer.toHexString(this.reason) + " - " + CapiIOException.capiInfo2Str(this.reason) + "\n";
            return string;
        }
    }

    public static class HoldInd
    extends SupServiceInd {
        private int reason;

        public HoldInd(Rider rider) {
            super(rider);
            this.reason = rider.readWord();
        }

        public int getReason() {
            return this.reason;
        }

        public String toString() {
            String string = super.toString();
            string = string + "reason   = 0x" + Integer.toHexString(this.reason) + " - " + CapiIOException.capiInfo2Str(this.reason) + "\n";
            return string;
        }
    }
}

