/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.facility;

import javax.swing.tree.DefaultMutableTreeNode;
import uk.co.mmscomputing.device.capi.MsgIn;
import uk.co.mmscomputing.device.capi.Rider;
import uk.co.mmscomputing.device.capi.facility.CallDeflectionConf;
import uk.co.mmscomputing.device.capi.facility.CallForwardConf;
import uk.co.mmscomputing.device.capi.facility.FacilityConf;

public class SupServiceConf
extends FacilityConf {
    protected int function;

    public SupServiceConf(Rider rider) {
        super(rider);
        this.function = rider.readWord();
        rider.structBegin();
    }

    public static MsgIn create(Rider rider) {
        int n = rider.readWord();
        rider.structBegin();
        switch (n) {
            case 0: {
                return new GetSupportedServicesConf(rider);
            }
            case 1: {
                return new ListenConf(rider);
            }
            case 2: {
                return new HoldConf(rider);
            }
            case 3: {
                return new RetrieveConf(rider);
            }
            case 6: {
                return new ECTConf(rider);
            }
            case 9: {
                return new CallForwardConf.ActivateConf(rider);
            }
            case 10: {
                return new CallForwardConf.DeactivateConf(rider);
            }
            case 11: {
                return new CallForwardConf.InterrogateParametersConf(rider);
            }
            case 12: {
                return new CallForwardConf.InterrogateNumbersConf(rider);
            }
            case 13: {
                return new CallDeflectionConf(rider);
            }
        }
        throw new IllegalArgumentException();
    }

    public int getFunctionNo() {
        return this.function;
    }

    public String toString() {
        String string = super.toString();
        string = string + "function : " + this.function + "\n\t";
        return string;
    }

    public static class ECTConf
    extends SupServiceConf {
        public ECTConf(Rider rider) {
            super(rider);
            if (this.info == 0) {
                this.info = rider.readWord();
            }
        }
    }

    public static class RetrieveConf
    extends SupServiceConf {
        public RetrieveConf(Rider rider) {
            super(rider);
            if (this.info == 0) {
                this.info = rider.readWord();
            }
        }
    }

    public static class HoldConf
    extends SupServiceConf {
        public HoldConf(Rider rider) {
            super(rider);
            if (this.info == 0) {
                this.info = rider.readWord();
            }
        }
    }

    public static class ListenConf
    extends SupServiceConf {
        public ListenConf(Rider rider) {
            super(rider);
            if (this.info == 0) {
                this.info = rider.readWord();
            }
        }
    }

    public static class GetSupportedServicesConf
    extends SupServiceConf {
        private static final String[] serviceStrings = new String[]{"Hold/Retrieve", "Terminal Portability", "Explicit Call Transfer", "Three-Party-Conference", "Call-Forwarding", "Call-Deflection", "Malicious Call Identification", "Completion of Calls to Busy Subscriber", "Message Waiting Indication", "Completion of Calls on No Reply", "Conference call"};
        private int services;

        public GetSupportedServicesConf(Rider rider) {
            super(rider);
            if (this.info == 0) {
                this.info = rider.readWord();
                this.services = rider.readDWord();
            }
        }

        public int getSupportedServices() {
            return this.services;
        }

        public boolean isSupported(int n) {
            return (this.services & 1 << n) != 0;
        }

        public boolean isHoldRetrieveSupported() {
            return this.isSupported(0);
        }

        public boolean isTerminalPortabilitySupported() {
            return this.isSupported(1);
        }

        public boolean isECTSupported() {
            return this.isSupported(2);
        }

        public boolean is3PTYSupported() {
            return this.isSupported(3);
        }

        public boolean isCallForwardingSupported() {
            return this.isSupported(4);
        }

        public boolean isCallDeflectionSupported() {
            return this.isSupported(5);
        }

        public boolean isMCIDSupported() {
            return this.isSupported(6);
        }

        public boolean isCCBSSupported() {
            return this.isSupported(7);
        }

        public boolean isMWISupported() {
            return this.isSupported(8);
        }

        public boolean isCCNRSupported() {
            return this.isSupported(9);
        }

        public boolean isCONFSupported() {
            return this.isSupported(10);
        }

        public String toString() {
            String string = super.toString();
            string = string + "Supported Services = 0" + Integer.toBinaryString(this.services) + "b\n";
            for (int i = 0; i < serviceStrings.length; ++i) {
                if (!this.isSupported(i)) continue;
                string = string + "Bit[" + i + "] - " + serviceStrings[i] + "\n";
            }
            return string;
        }

        public DefaultMutableTreeNode toTree() {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Supported Services = 0" + Integer.toBinaryString(this.services) + "b");
            for (int i = 0; i < serviceStrings.length; ++i) {
                if (!this.isSupported(i)) continue;
                defaultMutableTreeNode.add(new DefaultMutableTreeNode("Bit[" + i + "] - " + serviceStrings[i]));
            }
            return defaultMutableTreeNode;
        }
    }
}

