/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.facility;

import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.facility.FacilityReq;

public class DTMFReq
extends FacilityReq {
    public static final int DTMF_START = 1;
    public static final int DTMF_STOP = 2;
    public static final int DTMF_SEND = 3;

    public DTMFReq(int n, int n2, StructOut structOut) {
        super(n, n2, 1, structOut);
    }

    public DTMFReq(int n, int n2, int n3, String string) {
        this(n, n2, DTMFReq.getFacReqParam(n3, string));
    }

    public DTMFReq(int n, int n2, int n3) {
        this(n, n2, DTMFReq.getFacReqParam(n3));
    }

    private static StructOut getFacReqParam(int n) {
        StructOut structOut = new StructOut(10);
        structOut.writeWord(n);
        structOut.writeWord(40);
        structOut.writeWord(40);
        structOut.writeByte(0);
        structOut.writeByte(2);
        structOut.writeWord(0);
        return structOut;
    }

    private static StructOut getFacReqParam(int n, String string) {
        int n2 = string.length();
        StructOut structOut = new StructOut(10 + n2);
        structOut.writeWord(n);
        structOut.writeWord(40);
        structOut.writeWord(40);
        structOut.writeByte(n2);
        structOut.writeData(string.getBytes(), 0, n2);
        structOut.writeByte(2);
        structOut.writeWord(0);
        return structOut;
    }

    public static DTMFReq getStartReq(int n, int n2) {
        return new DTMFReq(n, n2 & 0xFFFF, 1);
    }

    public static DTMFReq getStopReq(int n, int n2) {
        return new DTMFReq(n, n2 & 0xFFFF, 2);
    }

    public static DTMFReq getSendReq(int n, int n2, String string) {
        return new DTMFReq(n, n2 & 0xFFFF, 3, string);
    }
}

