/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi.exception;

import uk.co.mmscomputing.device.capi.exception.CapiException;

public class CapiIOException
extends CapiException {
    private int errno = 0;

    public CapiIOException(int n) {
        super("\n" + CapiIOException.capiInfo2Str(n));
        this.errno = n;
    }

    public int getErrNo() {
        return this.errno;
    }

    public static String capiInfo2Str(int n) {
        switch (n) {
            case -6: {
                return "Unrecoverable network error.";
            }
            case -5: {
                return "Do not call 32 bit function in 64 bit environment.";
            }
            case -4: {
                return "Do not call 64 bit function in 32 bit environment.";
            }
            case -3: {
                return "No Capi Serial Number available!";
            }
            case -2: {
                return "No Capi Version Information available!";
            }
            case -1: {
                return "No Capi Manufacturer Information available!";
            }
            case 0: {
                return "Request accepted";
            }
            case 1: {
                return "NCPI not supported by current protocol, NCPI ignored";
            }
            case 2: {
                return "Flags not supported by current protocol, flags ignored";
            }
            case 3: {
                return "Alert already sent by another application";
            }
            case 4097: {
                return "Too many applications";
            }
            case 4098: {
                return "Logical block size too small, must be at least 128 Bytes";
            }
            case 4099: {
                return "Buffer exceeds 64 kByte";
            }
            case 4100: {
                return "Message buffer size too small, must be at least 1024 Bytes";
            }
            case 4101: {
                return "Max. number of logical connections not supported";
            }
            case 4102: {
                return "Reserved";
            }
            case 4103: {
                return "The message could not be accepted because of an internal busy condition";
            }
            case 4104: {
                return "OS resource error (no memory ?)";
            }
            case 4105: {
                return "CAPI not installed";
            }
            case 4106: {
                return "Controller does not support external equipment";
            }
            case 4107: {
                return "Controller does only support external equipment";
            }
            case 4353: {
                return "Illegal application number";
            }
            case 4354: {
                return "Illegal command or subcommand or message length less than 12 bytes";
            }
            case 4355: {
                return "The message could not be accepted because of a queue full condition !! The error code does not imply that CAPI cannot receive messages directed to another controller, PLCI or NCCI";
            }
            case 4356: {
                return "Queue is empty";
            }
            case 4357: {
                return "Queue overflow, a message was lost !! This indicates a configuration error. The only recovery from this error is to perform a CAPI_RELEASE";
            }
            case 4358: {
                return "Unknown notification parameter";
            }
            case 4359: {
                return "The Message could not be accepted because of an internal busy condition";
            }
            case 4360: {
                return "OS Resource error (no memory ?)";
            }
            case 4361: {
                return "CAPI not installed";
            }
            case 4362: {
                return "Controller does not support external equipment";
            }
            case 4363: {
                return "Controller does only support external equipment";
            }
            case 8193: {
                return "Message not supported in current state";
            }
            case 8194: {
                return "Illegal Controller / PLCI / NCCI";
            }
            case 8195: {
                return "Out of PLCI";
            }
            case 8196: {
                return "Out of NCCI";
            }
            case 8197: {
                return "Out of LISTEN";
            }
            case 8198: {
                return "Out of FAX resources (protocol T.30)";
            }
            case 8199: {
                return "Illegal message parameter coding";
            }
            case 12289: {
                return "B1 protocol not supported";
            }
            case 12290: {
                return "B2 protocol not supported";
            }
            case 12291: {
                return "B3 protocol not supported";
            }
            case 12292: {
                return "B1 protocol parameter not supported";
            }
            case 12293: {
                return "B2 protocol parameter not supported";
            }
            case 12294: {
                return "B3 protocol parameter not supported";
            }
            case 12295: {
                return "B protocol combination not supported";
            }
            case 12296: {
                return "NCPI not supported";
            }
            case 12297: {
                return "CIP Value unknown";
            }
            case 12298: {
                return "Flags not supported (reserved bits)";
            }
            case 12299: {
                return "Facility not supported";
            }
            case 12300: {
                return "Data length not supported by current protocol";
            }
            case 12301: {
                return "Reset procedure not supported by current protocol";
            }
            case 13057: {
                return "Protocol error layer 1 (broken line or B-channel removed by signalling protocol)";
            }
            case 13058: {
                return "Protocol error layer 2";
            }
            case 13059: {
                return "Protocol error layer 3";
            }
            case 13060: {
                return "Another application got that call";
            }
            case 13073: {
                return "Connecting not successful (remote station is no FAX G3 machine)";
            }
            case 13074: {
                return "Connecting not successful (training error)";
            }
            case 13075: {
                return "Disconnected before transfer (remote station does not support transfer mode, e.g. resolution)";
            }
            case 13076: {
                return "Disconnected during transfer (remote abort)";
            }
            case 13077: {
                return "Disconnected during transfer (remote procedure error, e.g. unsuccessful repetition of T.30 commands)";
            }
            case 13078: {
                return "Disconnected during transfer (local tx data underrun)";
            }
            case 13079: {
                return "Disconnected during transfer (local rx data overflow)";
            }
            case 13080: {
                return "Disconnected during transfer (local abort)";
            }
            case 13081: {
                return "Illegal parameter coding (e.g. SFF coding error)";
            }
            case 13328: {
                return "Normal call clearing";
            }
            case 13329: {
                return "User busy";
            }
            case 13330: {
                return "No user responding";
            }
            case 13333: {
                return "Call rejected";
            }
            case 13408: {
                return "Mandatory information element is missing";
            }
            case 13409: {
                return "Message type nonexistent or not implemented";
            }
            case 13410: {
                return "Message not compatible with call state or message type nonexistent or not implemented";
            }
            case 13411: {
                return "Information element nonexistent or not implemented";
            }
            case 13412: {
                return "Invalid information element contents";
            }
            case 13413: {
                return "Message not compatible with call state";
            }
            case 13414: {
                return "Recovery on timer expiry";
            }
            case 13423: {
                return "Protocol error, unspecified";
            }
            case 13441: {
                return "Unallocated (unassigned) number";
            }
            case 13442: {
                return "No route to specified transit network";
            }
            case 13443: {
                return "No route to destination";
            }
            case 13446: {
                return "Channel unacceptable";
            }
            case 13447: {
                return "Call awarded and being delivered in an established channel";
            }
            case 13456: {
                return "Normal call clearing";
            }
            case 13457: {
                return "User busy";
            }
            case 13458: {
                return "No user responding";
            }
            case 13459: {
                return "No answer from user (user alerted)";
            }
            case 13461: {
                return "Call rejected";
            }
            case 13462: {
                return "Number changed";
            }
            case 13466: {
                return "Non-selected user clearing";
            }
            case 13467: {
                return "Destination out of order";
            }
            case 13468: {
                return "Invalid number format";
            }
            case 13469: {
                return "Facility rejected";
            }
            case 13470: {
                return "Response to STATUS ENQUIRY";
            }
            case 13471: {
                return "Normal, unspecified";
            }
            case 13474: {
                return "No circuit / channel available";
            }
            case 13478: {
                return "Network out of order";
            }
            case 13481: {
                return "Temporary failure";
            }
            case 13482: {
                return "Switching equipment congestion";
            }
            case 13483: {
                return "Access information discarded";
            }
            case 13484: {
                return "Requested circuit / channel not available";
            }
            case 13487: {
                return "Resources unavailable, unspecified";
            }
            case 13489: {
                return "Quality of service unavailable";
            }
            case 13490: {
                return "Requested facility not subscribed";
            }
            case 13497: {
                return "Bearer capability not authorized";
            }
            case 13498: {
                return "Bearer capability not presently available";
            }
            case 13503: {
                return "Service or option not available, unspecified";
            }
            case 13505: {
                return "Bearer capability not implemented";
            }
            case 13506: {
                return "Channel type not implemented";
            }
            case 13509: {
                return "Requested facility not implemented";
            }
            case 13510: {
                return "Only restricted digital information bearer capability is available";
            }
            case 13519: {
                return "Service or option not implemented, unspecified";
            }
            case 13521: {
                return "Invalid call reference value";
            }
            case 13522: {
                return "Identified channel does not exist";
            }
            case 13523: {
                return "A suspended call exists, but this call identity does not";
            }
            case 13524: {
                return "Call identity in use";
            }
            case 13525: {
                return "No call suspended";
            }
            case 13526: {
                return "Call having the requested call identity has been cleared";
            }
            case 13528: {
                return "Incompatible destination";
            }
            case 13531: {
                return "Invalid transit network selection";
            }
            case 13535: {
                return "Invalid message, unspecified";
            }
            case 13536: {
                return "Mandatory information element is missing";
            }
            case 13537: {
                return "Message type non-existent or not implemented";
            }
            case 13538: {
                return "Message not compatible with call state or message type non-existent or not implemented";
            }
            case 13539: {
                return "Information element non-existent or not implemented";
            }
            case 13540: {
                return "Invalid information element contents";
            }
            case 13541: {
                return "Message not compatible with call state";
            }
            case 13542: {
                return "Recovery on timer expiry";
            }
            case 13551: {
                return "Protocol error, unspecified";
            }
            case 13567: {
                return "Interworking, unspecified";
            }
            case 13568: {
                return "Normal end of connection";
            }
            case 13569: {
                return "Carrier lost";
            }
            case 13570: {
                return "Error in negotation, i.e. no modem with error correction at the other end";
            }
            case 13571: {
                return "No answer to protocol request";
            }
            case 13572: {
                return "Remote modem only works in synchronous mode";
            }
            case 13573: {
                return "Framing fails";
            }
            case 13574: {
                return "Protocol negotiation fails";
            }
            case 13575: {
                return "Other modem sends wrong protocol request";
            }
            case 13576: {
                return "Sync information (data or flags) missing";
            }
            case 13577: {
                return "Normal end of connection from the other modem";
            }
            case 13578: {
                return "No answer from other modem";
            }
            case 13579: {
                return "Protocol error";
            }
            case 13580: {
                return "Error in compression";
            }
            case 13581: {
                return "No connect (timeout or wrong modulation)";
            }
            case 13582: {
                return "No protocol fall-back allowed";
            }
            case 13583: {
                return "No modem or fax at requested number";
            }
            case 13584: {
                return "Handshake error";
            }
        }
        return "No additional information available for capi reason = 0x" + Integer.toHexString(n);
    }
}

