/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.IOException;
import java.io.OutputStream;

public class StructOut {
    public static final StructOut empty = new StructOut(0);
    private byte[] data;
    private int index;
    static String[] hexs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public StructOut(int n) {
        this.data = new byte[n];
        this.index = 0;
    }

    public StructOut(byte[] byArray) {
        this.data = byArray;
        this.index = byArray.length;
    }

    public StructOut(String string) {
        this.data = string.getBytes();
        this.index = string.length();
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getLength() {
        return this.index < 255 ? this.index + 1 : this.index + 3;
    }

    public void writeByte(int n) {
        try {
            this.data[this.index++] = (byte)n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println(this.getClass().getName() + ".writeByte:\n\tINTERNAL ERROR !!! Please send error log to mmsc.\n\t" + indexOutOfBoundsException);
            System.err.println(this.getClass().getName() + ".writeByte:\n\tINTERNAL ERROR !!! Please send error log to mmsc.\n\t" + indexOutOfBoundsException);
            indexOutOfBoundsException.printStackTrace();
        }
    }

    public void writeWord(int n) {
        try {
            this.data[this.index++] = (byte)n;
            this.data[this.index++] = (byte)(n >> 8);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println(this.getClass().getName() + ".writeWord:\n\tINTERNAL ERROR !!! Please send error log to mmsc.\n\t" + indexOutOfBoundsException);
            System.err.println(this.getClass().getName() + ".writeWord:\n\tINTERNAL ERROR !!! Please send error log to mmsc.\n\t" + indexOutOfBoundsException);
            indexOutOfBoundsException.printStackTrace();
        }
    }

    public void writeDWord(int n) {
        try {
            this.data[this.index++] = (byte)n;
            this.data[this.index++] = (byte)(n >> 8);
            this.data[this.index++] = (byte)(n >> 16);
            this.data[this.index++] = (byte)(n >> 24);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println(this.getClass().getName() + ".writeWord:\n\tINTERNAL ERROR !!! Please send error log to mmsc.\n\t" + indexOutOfBoundsException);
            System.err.println(this.getClass().getName() + ".writeWord:\n\tINTERNAL ERROR !!! Please send error log to mmsc.\n\t" + indexOutOfBoundsException);
            indexOutOfBoundsException.printStackTrace();
        }
    }

    public void writeQWord(long l) {
        this.writeDWord((int)(l & 0xFFFFFFFFL));
        this.writeDWord((int)(l >> 32 & 0xFFFFFFFFL));
    }

    public void writeData(byte[] byArray, int n, int n2) {
        try {
            System.arraycopy(byArray, n, this.data, this.index, n2);
            this.index += n2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println(this.getClass().getName() + "\n\tINTERNAL ERROR !!! Please send error log to mmsc.\n\t" + indexOutOfBoundsException);
            System.err.println("buffer.length = " + this.data.length);
            System.err.println("index         = " + this.index);
            System.err.println("length        = " + n2);
            System.err.println(this.getClass().getName() + "\n\tINTERNAL ERROR !!! Please send error log to mmsc.\n\t" + indexOutOfBoundsException);
            indexOutOfBoundsException.printStackTrace();
        }
    }

    public void writeStruct() {
        this.writeByte(0);
    }

    public void writeStruct(StructOut structOut) {
        int n = structOut.getBytes().length;
        if (n == 0) {
            this.writeByte(0);
        } else {
            if (n < 255) {
                this.writeByte(n);
            } else {
                this.writeByte(255);
                this.writeWord(n);
            }
            this.writeData(structOut.getBytes(), 0, n);
        }
    }

    public void dump() {
        System.err.println(this.getClass().getName() + ".dump : ");
        for (int i = 0; i < this.index; ++i) {
            int n = this.data[i] & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() > 2) {
                string = string.substring(string.length() - 2);
            } else if (string.length() < 2) {
                string = "0" + string;
            }
            System.err.println("\t[" + i + "] = 0x" + string + " " + n);
        }
        System.err.println();
    }

    public void dump(OutputStream outputStream) throws IOException {
        outputStream.write((this.getClass().getName() + ".dump : \r\n").getBytes());
        for (int i = 0; i < this.index; ++i) {
            int n = this.data[i] & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() > 2) {
                string = string.substring(string.length() - 2);
            } else if (string.length() < 2) {
                string = "0" + string;
            }
            outputStream.write(("\t[" + i + "] = 0x" + string + " " + n + "\r\n").getBytes());
        }
        outputStream.write(13);
        outputStream.write(10);
    }

    public String toString() {
        return this.getClass().getName() + "\n";
    }

    public static String toString(byte[] byArray) {
        int n;
        String string = "\n";
        for (n = 0; n < byArray.length; ++n) {
            string = string + " ";
            string = string + hexs[byArray[n] >> 4 & 0xF];
            string = string + hexs[byArray[n] & 0xF];
            if ((n + 1) % 8 != 0) continue;
            string = string + "\n";
        }
        if ((n + 1) % 8 != 0) {
            string = string + "\n";
        }
        return string;
    }
}

