/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiFaxDetector;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiPlugin;
import uk.co.mmscomputing.device.capi.CapiSystem;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;
import uk.co.mmscomputing.device.capi.protocol.FaxBProtocol;
import uk.co.mmscomputing.device.capi.protocol.SpeechProtocol;
import uk.co.mmscomputing.device.fax.FaxCallHandler;
import uk.co.mmscomputing.device.fax.FaxReceiver;
import uk.co.mmscomputing.device.fax.FaxReceiverListener;
import uk.co.mmscomputing.device.fax.FaxReceiverMetadata;
import uk.co.mmscomputing.device.phone.PhoneAnswerer;
import uk.co.mmscomputing.device.phone.PhoneAnswererListener;
import uk.co.mmscomputing.device.phone.PhoneAnswererMetadata;
import uk.co.mmscomputing.device.phone.PhoneCallHandler;
import uk.co.mmscomputing.util.metadata.Metadata;

public class CapiVoicePlugin
implements CapiPlugin {
    private PhoneAnswerer phoneAnswerer = null;
    private FaxReceiver faxReceiver = null;
    private static CapiVoicePlugin defaultPlugin = null;

    public void addListener(PhoneAnswererListener phoneAnswererListener) {
        if (this.phoneAnswerer == null) {
            this.phoneAnswerer = new PhoneAnswerer();
        }
        this.phoneAnswerer.addListener(phoneAnswererListener);
    }

    public void addListener(FaxReceiverListener faxReceiverListener) {
        if (this.faxReceiver == null) {
            this.faxReceiver = new FaxReceiver();
        }
        this.faxReceiver.addListener(faxReceiverListener);
    }

    public void update(Object object, Metadata metadata) {
        if (object instanceof CapiMetadata.Indication) {
            int n;
            Object object2;
            CapiMetadata.Indication indication = (CapiMetadata.Indication)object;
            if (!indication.isAccepted()) {
                try {
                    if (this.phoneAnswerer != null) {
                        indication.setPlugin(this);
                        object2 = new PhoneAnswererMetadata();
                        ((PhoneAnswererMetadata)object2).setController(indication.getController());
                        ((PhoneAnswererMetadata)object2).setLocalNo(indication.localno);
                        ((PhoneAnswererMetadata)object2).setRemoteNo(indication.remoteno);
                        ((PhoneAnswererMetadata)object2).setState(1);
                        this.phoneAnswerer.fireListenerUpdate(PhoneAnswererMetadata.STATE, (PhoneAnswererMetadata)object2);
                        n = ((PhoneAnswererMetadata)object2).getPickUpTime();
                        if (n >= 0) {
                            indication.setAccept(n * 1000, ((PhoneAnswererMetadata)object2).getBlocker());
                        }
                    }
                }
                catch (Exception exception) {
                    System.out.println("9\b" + this.getClass().getName() + ".update\n\t" + exception);
                    System.err.println(this.getClass().getName() + ".update\n\t" + exception);
                    exception.printStackTrace();
                }
            }
            if (!indication.isAccepted()) {
                try {
                    if (this.faxReceiver != null) {
                        indication.setPlugin(this);
                        object2 = new FaxReceiverMetadata();
                        ((FaxReceiverMetadata)object2).setLocalNo(indication.localno);
                        ((FaxReceiverMetadata)object2).setRemoteNo(indication.remoteno);
                        ((FaxReceiverMetadata)object2).setState(1);
                        this.faxReceiver.fireListenerUpdate(FaxReceiverMetadata.STATE, (FaxReceiverMetadata)object2);
                        n = ((FaxReceiverMetadata)object2).getPickUpTime();
                        String string = ((FaxReceiverMetadata)object2).getHeader();
                        String string2 = ((FaxReceiverMetadata)object2).getLocalNo();
                        if (n >= 0) {
                            indication.setAccept(n * 1000, ((FaxReceiverMetadata)object2).getBlocker());
                            indication.setProtocol(new FaxBProtocol(0, 0, string2, string));
                        }
                    }
                }
                catch (Exception exception) {
                    System.out.println("9\b" + this.getClass().getName() + ".update\n\t" + exception);
                    System.err.println(this.getClass().getName() + ".update\n\t" + exception);
                    exception.printStackTrace();
                }
            }
        }
    }

    public void serve(CapiChannel capiChannel) {
        BProtocol bProtocol = capiChannel.getProtocol();
        if (bProtocol instanceof SpeechProtocol) {
            if (this.faxReceiver != null) {
                new CapiFaxDetector(capiChannel).start();
            }
            new VoiceThread(capiChannel).start();
        } else if (bProtocol instanceof FaxBProtocol) {
            new FaxThread(capiChannel).start();
        } else {
            System.out.println("3\b" + this.getClass().getName() + ".serve:\n\tUnknown Protocol.");
            try {
                capiChannel.close();
            }
            catch (Exception exception) {
                System.out.println("3\b" + this.getClass().getName() + ".serve:\n\t" + exception);
            }
        }
    }

    public static CapiVoicePlugin getDefaultPlugin() {
        if (defaultPlugin != null) {
            return defaultPlugin;
        }
        try {
            String string = System.getProperty("os.name");
            if (string.startsWith("Linux") || string.startsWith("Windows")) {
                defaultPlugin = new CapiVoicePlugin();
                CapiSystem.getSystem().addPlugin(defaultPlugin);
            } else {
                System.out.println("9\buk.co.mmscomputing.device.capi.CapiVoicePlugin.getDevice:\n\tUnsupported Operating System.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("9\buk.co.mmscomputing.device.capi.CapiVoicePlugin.getDevice:\n\tCould not open CapiVoicePlugin\n\t" + exception);
        }
        return defaultPlugin;
    }

    private class FaxThread
    extends Thread {
        CapiChannel channel;

        public FaxThread(CapiChannel capiChannel) {
            this.channel = capiChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                FaxReceiverMetadata faxReceiverMetadata = new FaxReceiverMetadata();
                faxReceiverMetadata.setState(2);
                CapiVoicePlugin.this.faxReceiver.fireListenerUpdate(FaxReceiverMetadata.STATE, faxReceiverMetadata);
                FaxCallHandler faxCallHandler = faxReceiverMetadata.getHandler();
                faxCallHandler.run(this.channel.getLocalNo(), this.channel.getRemoteNo(), this.channel.getInputStream(), this.channel.getOutputStream());
                faxReceiverMetadata.setHandler(faxCallHandler);
                faxReceiverMetadata.setState(0);
                CapiVoicePlugin.this.faxReceiver.fireListenerUpdate(FaxReceiverMetadata.STATE, faxReceiverMetadata);
            }
            catch (Exception exception) {
                System.out.println("9\b" + this.getClass().getName() + ".run\n\tDisconnected call.\n\t" + exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    this.channel.close();
                }
                catch (Exception exception) {
                    System.out.println(this.getClass().getName() + ".run:\n\t" + exception);
                    System.out.println("3\b" + this.getClass().getName() + ".run:\n\t" + exception);
                }
            }
        }
    }

    private class VoiceThread
    extends Thread {
        CapiChannel channel;
        PhoneCallHandler pch;

        VoiceThread(CapiChannel capiChannel) {
            this.channel = capiChannel;
            this.pch = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                PhoneAnswererMetadata phoneAnswererMetadata = new PhoneAnswererMetadata();
                phoneAnswererMetadata.setState(2);
                CapiVoicePlugin.this.phoneAnswerer.fireListenerUpdate(PhoneAnswererMetadata.STATE, phoneAnswererMetadata);
                this.pch = phoneAnswererMetadata.getHandler();
                this.pch.run(this.channel.getLocalNo(), this.channel.getRemoteNo(), this.channel.getPCMInputStream(), this.channel.getPCMOutputStream());
                phoneAnswererMetadata.setHandler(this.pch);
                phoneAnswererMetadata.setChangedProtocol(this.channel.getChangedProtocol());
                phoneAnswererMetadata.setState(0);
                CapiVoicePlugin.this.phoneAnswerer.fireListenerUpdate(PhoneAnswererMetadata.STATE, phoneAnswererMetadata);
            }
            catch (Exception exception) {
                System.out.println("9\b" + this.getClass().getName() + ".run\n\tDisconnected call.\n\t" + exception);
                System.err.println(this.getClass().getName() + ".run\n\tDisconnected call.\n\t" + exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    this.channel.close();
                }
                catch (Exception exception) {
                    System.out.println("3\b" + this.getClass().getName() + ".run:\n\t" + exception);
                }
            }
        }
    }
}

