/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.IOException;
import uk.co.mmscomputing.concurrent.ArrayBlockingQueue;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.concurrent.TimeUnit;
import uk.co.mmscomputing.device.capi.CapiCallApplication;
import uk.co.mmscomputing.device.capi.CapiChannel;
import uk.co.mmscomputing.device.capi.CapiController;
import uk.co.mmscomputing.device.capi.CapiEnumerator;
import uk.co.mmscomputing.device.capi.CapiMetadata;
import uk.co.mmscomputing.device.capi.CapiNCC;
import uk.co.mmscomputing.device.capi.CapiPLC;
import uk.co.mmscomputing.device.capi.StructOut;
import uk.co.mmscomputing.device.capi.ctrl.ListenReq;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.ncc.ConnectB3ActiveInd;
import uk.co.mmscomputing.device.capi.plc.AlertReq;
import uk.co.mmscomputing.device.capi.plc.ConnectInd;
import uk.co.mmscomputing.device.capi.plc.ConnectResp;
import uk.co.mmscomputing.device.capi.protocol.BProtocol;
import uk.co.mmscomputing.device.capi.protocol.SpeechProtocol;
import uk.co.mmscomputing.device.capi.q931.BearerCapability;
import uk.co.mmscomputing.util.metadata.Metadata;

public class CapiServerApplication
extends CapiCallApplication {
    protected ArrayBlockingQueue incoming = new ArrayBlockingQueue(this.maxLogicalCon);

    public CapiServerApplication(Metadata metadata) throws CapiException {
        super(metadata);
    }

    public void run() {
        try {
            int n = this.md.getInt("capi.cipmask");
            CapiController[] capiControllerArray = CapiEnumerator.getControllers();
            for (int i = 0; i < capiControllerArray.length; ++i) {
                this.put(new ListenReq(this.appid, capiControllerArray[i].getId(), n));
            }
        }
        catch (IOException iOException) {
            this.md.fireListenerUpdate(iOException);
            iOException.printStackTrace();
        }
        super.run();
    }

    public void close() {
        try {
            CapiController[] capiControllerArray = CapiEnumerator.getControllers();
            for (int i = 0; i < capiControllerArray.length; ++i) {
                this.put(new ListenReq(this.appid, capiControllerArray[i].getId(), 0));
            }
        }
        catch (CapiException capiException) {
            // empty catch block
        }
        super.close();
        try {
            this.incoming.put(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public CapiChannel accept() throws InterruptedException {
        return (CapiChannel)this.incoming.take();
    }

    protected void received(CapiPLC capiPLC, ConnectInd connectInd) throws CapiException {
        new Thread(new Pickup(capiPLC, connectInd)).start();
    }

    protected void received(CapiNCC capiNCC, ConnectB3ActiveInd connectB3ActiveInd) throws CapiException {
        try {
            super.received(capiNCC, connectB3ActiveInd);
            if (capiNCC.isIncoming()) {
                this.incoming.put(capiNCC);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new CapiException(interruptedException.getMessage());
        }
    }

    private class Pickup
    implements Runnable {
        CapiPLC plc;
        ConnectInd msg;

        public Pickup(CapiPLC capiPLC, ConnectInd connectInd) {
            this.plc = capiPLC;
            this.msg = connectInd;
        }

        private void indicateCall() throws IOException {
            Object object;
            int n;
            CapiMetadata.Indication indication = new CapiMetadata.Indication(this.msg.lineid);
            indication.setController(this.plc.getCtrlId());
            indication.localno = this.msg.getLocalNo();
            indication.remoteno = this.msg.getRemoteNo();
            int n2 = CapiServerApplication.this.md.getInt("capi.bandwidth");
            indication.setProtocol(new SpeechProtocol(n2));
            CapiServerApplication.this.md.fireListenerUpdate(indication);
            BProtocol bProtocol = indication.getProtocol();
            if (bProtocol instanceof SpeechProtocol && (n = ((BearerCapability)(object = this.msg.getBearerCapability())).getSpeechCoding()) != -1) {
                this.plc.setSpeechCoding(n);
            }
            this.plc.setProtocol(bProtocol);
            this.plc.setLocalNo(indication.localno);
            this.plc.setRemoteNo(indication.remoteno);
            if (indication.accept && (object = indication.blocker) != null) {
                this.plc.setPickupBlocker((Semaphore)object);
                CapiServerApplication.this.put(new AlertReq(this.msg.appid, this.msg.lineid));
                try {
                    ((Semaphore)object).tryAcquire(indication.waitformsecs, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.plc.isOpen()) {
                return;
            }
            this.plc.setPickedUp(indication.gotPickedUp);
            object = indication.localno;
            String string = "";
            String[] stringArray = ((String)object).split("-");
            if (stringArray.length == 2) {
                object = stringArray[0];
                string = stringArray[1];
            }
            this.plc.setProtocol(indication.getProtocol());
            this.plc.setPlugin(indication.getPlugin());
            CapiServerApplication.this.put(new ConnectResp(this.msg.appid, this.msg.lineid, indication.rejectFlag, (StructOut)indication.getProtocol(), (String)object, string, StructOut.empty, StructOut.empty));
        }

        public void run() {
            Thread.currentThread().setName(this.getClass().getName() + ".0x" + Integer.toHexString(this.plc.getLineID()));
            try {
                this.indicateCall();
            }
            catch (IOException iOException) {
                CapiServerApplication.this.md.fireListenerUpdate(iOException);
            }
        }
    }
}

