/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import uk.co.mmscomputing.device.capi.CapiController;
import uk.co.mmscomputing.device.capi.CapiEnumerator;
import uk.co.mmscomputing.device.capi.exception.CapiInformation;
import uk.co.mmscomputing.util.metadata.Metadata;

public class CapiPanel
extends JPanel {
    private JPanel controller;
    private JPanel profile;

    public CapiPanel(Metadata metadata) throws CapiInformation {
        this.setLayout(new BorderLayout());
        this.profile = new JPanel(new BorderLayout());
        this.controller = this.createCtrlGroup(metadata);
        this.add((Component)this.controller, "North");
        this.add((Component)this.profile, "Center");
    }

    private JPanel createCtrlGroup(Metadata metadata) throws CapiInformation {
        CapiController[] capiControllerArray = CapiEnumerator.getControllers();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.setBorder(new EtchedBorder());
        if (capiControllerArray.length > 0) {
            int n;
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton[] jRadioButtonArray = new JRadioButton[capiControllerArray.length];
            for (n = 0; n < capiControllerArray.length; ++n) {
                CapiController capiController = capiControllerArray[n];
                JTree jTree = new JTree(capiController.getProfile().toTree());
                JScrollPane jScrollPane = new JScrollPane(jTree);
                JRadioButton jRadioButton = new JRadioButton(this.getRBAction(jScrollPane, metadata, capiController));
                buttonGroup.add(jRadioButton);
                jPanel.add(jRadioButton);
                jRadioButtonArray[n] = jRadioButton;
            }
            try {
                n = metadata.getInt("capi.controller.id", 1);
                jRadioButtonArray[n - 1].doClick();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                jRadioButtonArray[0].doClick();
            }
        }
        return jPanel;
    }

    private Action getRBAction(final JScrollPane jScrollPane, final Metadata metadata, final CapiController capiController) {
        return new AbstractAction(capiController.getName()){

            public void actionPerformed(ActionEvent actionEvent) {
                capiController.update(metadata);
                CapiPanel.this.profile.removeAll();
                CapiPanel.this.profile.add(jScrollPane);
                CapiPanel.this.profile.validate();
                CapiPanel.this.profile.repaint();
            }
        };
    }
}

