/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mmscomputing.device.capi;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import uk.co.mmscomputing.concurrent.Semaphore;
import uk.co.mmscomputing.device.capi.CapiConstants;
import uk.co.mmscomputing.device.capi.CapiNCC;
import uk.co.mmscomputing.device.capi.exception.CapiException;
import uk.co.mmscomputing.device.capi.ncc.DataB3Conf;
import uk.co.mmscomputing.device.capi.ncc.DataB3Req;

public class CapiOutputStream
extends OutputStream
implements CapiConstants {
    private static final int maxBuffers = 8;
    private byte[] buf;
    private int count = 0;
    private CapiNCC ncc;
    private boolean isopen;
    private Semaphore blocker = new Semaphore(7, true);
    private int current = 0;
    private byte[][] buffers = new byte[8][256];
    private DataB3Req[] dataB3Reqs = new DataB3Req[8];
    private int unconfirmed = 0;
    private boolean isdisconnected = false;
    private Semaphore ds = new Semaphore(0, true);

    CapiOutputStream(CapiNCC capiNCC) {
        this.ncc = capiNCC;
        this.isopen = true;
        this.buf = this.buffers[0];
    }

    protected synchronized boolean checkIsOpen() {
        if (!this.isopen) {
            return false;
        }
        this.isopen = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDataB3Reqs(int n) {
        DataB3Req[] dataB3ReqArray = this.dataB3Reqs;
        synchronized (this.dataB3Reqs) {
            if (this.dataB3Reqs[n] != null) {
                this.dataB3Reqs[n].release();
                this.dataB3Reqs[n] = null;
                --this.unconfirmed;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void releaseDataB3Reqs() {
        for (int i = 0; i < this.dataB3Reqs.length; ++i) {
            this.releaseDataB3Reqs(i);
        }
    }

    void received(DataB3Conf dataB3Conf) throws CapiException {
        this.releaseDataB3Reqs(dataB3Conf.getHandle());
        this.blocker.release();
        if (!this.isopen && this.unconfirmed == 0) {
            this.isdisconnected = true;
            this.ds.release();
        }
    }

    boolean isDisconnected() {
        return this.isdisconnected;
    }

    synchronized void disconnect() throws CapiException {
        this.isdisconnected = true;
        this.isopen = false;
        this.blocker.release();
        this.releaseDataB3Reqs();
        this.ds.release();
    }

    boolean isOpen() {
        return this.isopen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBuffer(int n) throws IOException {
        try {
            if (this.isdisconnected) {
                return;
            }
            this.blocker.acquire();
            if (this.isdisconnected) {
                this.blocker.release();
                return;
            }
            DataB3Req[] dataB3ReqArray = this.dataB3Reqs;
            synchronized (this.dataB3Reqs) {
                this.dataB3Reqs[this.current] = this.ncc.write(this.current, this.buf, n);
                this.current = (this.current + 1) % 8;
                this.buf = this.buffers[this.current];
                ++this.unconfirmed;
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (InterruptedException interruptedException) {
            this.disconnect();
        }
        {
            return;
        }
    }

    public void write(int n) throws IOException {
        if (!this.isopen) {
            throw new ClosedChannelException();
        }
        if (this.count == 256) {
            this.writeBuffer(this.count);
            this.count = 0;
        }
        this.buf[this.count++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException(this.getClass().getName() + ".write(byte[] b, int off, int len):\n\tb is null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException(this.getClass().getName() + ".write(byte[] b, int off, int len):\n\tindex off or len out of bounds.");
        }
        if (this.count > 0) {
            this.writeBuffer(this.count);
            this.count = 0;
        }
        while (n2 > 256) {
            System.arraycopy(byArray, n, this.buf, 0, 256);
            this.writeBuffer(256);
            n2 -= 256;
            n += 256;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buf, 0, n2);
            this.writeBuffer(n2);
        }
    }

    public void flush() throws IOException {
        if (!this.isopen) {
            throw new ClosedChannelException();
        }
        if (this.count > 0) {
            this.writeBuffer(this.count);
            this.count = 0;
        }
    }

    public void close() throws IOException {
        if (this.checkIsOpen()) {
            this.writeBuffer(this.count);
            try {
                this.ds.acquire();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.ds.release();
            this.ncc.closedOutput();
        } else {
            try {
                this.ds.acquire();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.ds.release();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

